"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .resource_type import ResourceType


class OAuthKeyConfigurationType(ResourceType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'key_id': 'str',
        'algorithm': 'str',
        'key': 'str',
        'expiration_date': 'str'
    }

    attribute_map = {
        'key_id': 'keyId',
        'algorithm': 'algorithm',
        'key': 'key',
        'expiration_date': 'expirationDate'
    }

    def __init__(self, key_id=None,algorithm=None,key=None,expiration_date=None):
        self._key_id = None
        self._algorithm = None
        self._key = None
        self._expiration_date = None

        if key_id is not None:
            self.key_id = key_id
        if algorithm is not None:
            self.algorithm = algorithm
        if key is not None:
            self.key = key
        if expiration_date is not None:
            self.expiration_date = expiration_date

    @property
    def key_id(self):
        return self._key_id
    
    @key_id.setter
    def key_id(self, key_id):
        self._key_id = key_id

    @property
    def algorithm(self):
        return self._algorithm
    
    @algorithm.setter
    def algorithm(self, algorithm):
        self._algorithm = algorithm

    @property
    def key(self):
        return self._key
    
    @key.setter
    def key(self, key):
        self._key = key

    @property
    def expiration_date(self):
        return self._expiration_date
    
    @expiration_date.setter
    def expiration_date(self, expiration_date):
        self._expiration_date = expiration_date


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, OAuthKeyConfigurationType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
