"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .v_cloud_extensible_type import VCloudExtensibleType


class NetworkServiceInsertionType(VCloudExtensibleType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'id': 'str',
        'category': 'str',
        'category_type': 'str',
        'vendor_templates': 'list[VendorTemplateType]'
    }

    attribute_map = {
        'name': 'name',
        'id': 'id',
        'category': 'category',
        'category_type': 'categoryType',
        'vendor_templates': 'vendorTemplates'
    }

    def __init__(self, name=None,id=None,category=None,category_type=None,vendor_templates=None):
        self._name = None
        self._id = None
        self._category = None
        self._category_type = None
        self._vendor_templates = None

        if name is not None:
            self.name = name
        if id is not None:
            self.id = id
        if category is not None:
            self.category = category
        if category_type is not None:
            self.category_type = category_type
        if vendor_templates is not None:
            self.vendor_templates = vendor_templates

    @property
    def name(self):
        return self._name
    
    @name.setter
    def name(self, name):
        self._name = name

    @property
    def id(self):
        return self._id
    
    @id.setter
    def id(self, id):
        self._id = id

    @property
    def category(self):
        return self._category
    
    @category.setter
    def category(self, category):
        self._category = category

    @property
    def category_type(self):
        return self._category_type
    
    @category_type.setter
    def category_type(self, category_type):
        self._category_type = category_type

    @property
    def vendor_templates(self):
        return self._vendor_templates
    
    @vendor_templates.setter
    def vendor_templates(self, vendor_templates):
        self._vendor_templates = vendor_templates


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, NetworkServiceInsertionType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
