"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .v_cloud_extensible_type import VCloudExtensibleType


class NatRuleType(VCloudExtensibleType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'description': 'str',
        'rule_type': 'str',
        'is_enabled': 'bool',
        'id': 'int',
        'gateway_nat_rule': 'GatewayNatRuleType',
        'one_to_one_basic_rule': 'NatOneToOneBasicRuleType',
        'one_to_one_vm_rule': 'NatOneToOneVmRuleType',
        'port_forwarding_rule': 'NatPortForwardingRuleType',
        'vm_rule': 'NatVmRuleType'
    }

    attribute_map = {
        'description': 'description',
        'rule_type': 'ruleType',
        'is_enabled': 'isEnabled',
        'id': 'id',
        'gateway_nat_rule': 'gatewayNatRule',
        'one_to_one_basic_rule': 'oneToOneBasicRule',
        'one_to_one_vm_rule': 'oneToOneVmRule',
        'port_forwarding_rule': 'portForwardingRule',
        'vm_rule': 'vmRule'
    }

    def __init__(self, description=None,rule_type=None,is_enabled=None,id=None,gateway_nat_rule=None,one_to_one_basic_rule=None,one_to_one_vm_rule=None,port_forwarding_rule=None,vm_rule=None):
        self._description = None
        self._rule_type = None
        self._is_enabled = None
        self._id = None
        self._gateway_nat_rule = None
        self._one_to_one_basic_rule = None
        self._one_to_one_vm_rule = None
        self._port_forwarding_rule = None
        self._vm_rule = None

        if description is not None:
            self.description = description
        if rule_type is not None:
            self.rule_type = rule_type
        if is_enabled is not None:
            self.is_enabled = is_enabled
        if id is not None:
            self.id = id
        if gateway_nat_rule is not None:
            self.gateway_nat_rule = gateway_nat_rule
        if one_to_one_basic_rule is not None:
            self.one_to_one_basic_rule = one_to_one_basic_rule
        if one_to_one_vm_rule is not None:
            self.one_to_one_vm_rule = one_to_one_vm_rule
        if port_forwarding_rule is not None:
            self.port_forwarding_rule = port_forwarding_rule
        if vm_rule is not None:
            self.vm_rule = vm_rule

    @property
    def description(self):
        return self._description
    
    @description.setter
    def description(self, description):
        self._description = description

    @property
    def rule_type(self):
        return self._rule_type
    
    @rule_type.setter
    def rule_type(self, rule_type):
        self._rule_type = rule_type

    @property
    def is_enabled(self):
        return self._is_enabled
    
    @is_enabled.setter
    def is_enabled(self, is_enabled):
        self._is_enabled = is_enabled

    @property
    def id(self):
        return self._id
    
    @id.setter
    def id(self, id):
        self._id = id

    @property
    def gateway_nat_rule(self):
        return self._gateway_nat_rule
    
    @gateway_nat_rule.setter
    def gateway_nat_rule(self, gateway_nat_rule):
        self._gateway_nat_rule = gateway_nat_rule

    @property
    def one_to_one_basic_rule(self):
        return self._one_to_one_basic_rule
    
    @one_to_one_basic_rule.setter
    def one_to_one_basic_rule(self, one_to_one_basic_rule):
        self._one_to_one_basic_rule = one_to_one_basic_rule

    @property
    def one_to_one_vm_rule(self):
        return self._one_to_one_vm_rule
    
    @one_to_one_vm_rule.setter
    def one_to_one_vm_rule(self, one_to_one_vm_rule):
        self._one_to_one_vm_rule = one_to_one_vm_rule

    @property
    def port_forwarding_rule(self):
        return self._port_forwarding_rule
    
    @port_forwarding_rule.setter
    def port_forwarding_rule(self, port_forwarding_rule):
        self._port_forwarding_rule = port_forwarding_rule

    @property
    def vm_rule(self):
        return self._vm_rule
    
    @vm_rule.setter
    def vm_rule(self, vm_rule):
        self._vm_rule = vm_rule


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, NatRuleType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
