"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .entity_type import EntityType


class MultisiteType(EntityType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'rest_endpoint': 'str',
        'base_ui_endpoint': 'str',
        'tenant_ui_endpoint': 'str',
        'rest_endpoint_certificate': 'str'
    }

    attribute_map = {
        'rest_endpoint': 'restEndpoint',
        'base_ui_endpoint': 'baseUiEndpoint',
        'tenant_ui_endpoint': 'tenantUiEndpoint',
        'rest_endpoint_certificate': 'restEndpointCertificate'
    }

    def __init__(self, rest_endpoint=None,base_ui_endpoint=None,tenant_ui_endpoint=None,rest_endpoint_certificate=None):
        self._rest_endpoint = None
        self._base_ui_endpoint = None
        self._tenant_ui_endpoint = None
        self._rest_endpoint_certificate = None

        if rest_endpoint is not None:
            self.rest_endpoint = rest_endpoint
        if base_ui_endpoint is not None:
            self.base_ui_endpoint = base_ui_endpoint
        if tenant_ui_endpoint is not None:
            self.tenant_ui_endpoint = tenant_ui_endpoint
        if rest_endpoint_certificate is not None:
            self.rest_endpoint_certificate = rest_endpoint_certificate

    @property
    def rest_endpoint(self):
        return self._rest_endpoint
    
    @rest_endpoint.setter
    def rest_endpoint(self, rest_endpoint):
        self._rest_endpoint = rest_endpoint

    @property
    def base_ui_endpoint(self):
        return self._base_ui_endpoint
    
    @base_ui_endpoint.setter
    def base_ui_endpoint(self, base_ui_endpoint):
        self._base_ui_endpoint = base_ui_endpoint

    @property
    def tenant_ui_endpoint(self):
        return self._tenant_ui_endpoint
    
    @tenant_ui_endpoint.setter
    def tenant_ui_endpoint(self, tenant_ui_endpoint):
        self._tenant_ui_endpoint = tenant_ui_endpoint

    @property
    def rest_endpoint_certificate(self):
        return self._rest_endpoint_certificate
    
    @rest_endpoint_certificate.setter
    def rest_endpoint_certificate(self, rest_endpoint_certificate):
        self._rest_endpoint_certificate = rest_endpoint_certificate


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, MultisiteType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
