"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .v_cloud_extensible_type import VCloudExtensibleType


class MksTicketType(VCloudExtensibleType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'host': 'str',
        'vmx': 'str',
        'ticket': 'str',
        'port': 'int'
    }

    attribute_map = {
        'host': 'host',
        'vmx': 'vmx',
        'ticket': 'ticket',
        'port': 'port'
    }

    def __init__(self, host=None,vmx=None,ticket=None,port=None):
        self._host = None
        self._vmx = None
        self._ticket = None
        self._port = None

        if host is not None:
            self.host = host
        if vmx is not None:
            self.vmx = vmx
        if ticket is not None:
            self.ticket = ticket
        if port is not None:
            self.port = port

    @property
    def host(self):
        return self._host
    
    @host.setter
    def host(self, host):
        self._host = host

    @property
    def vmx(self):
        return self._vmx
    
    @vmx.setter
    def vmx(self, vmx):
        self._vmx = vmx

    @property
    def ticket(self):
        return self._ticket
    
    @ticket.setter
    def ticket(self, ticket):
        self._ticket = ticket

    @property
    def port(self):
        return self._port
    
    @port.setter
    def port(self, port):
        self._port = port


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, MksTicketType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
