"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .v_cloud_extensible_type import VCloudExtensibleType


class MediaSettingsType(VCloudExtensibleType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'device_id': 'str',
        'media_image': 'ReferenceType',
        'media_type': 'MediaTypeType',
        'media_state': 'MediaStateType',
        'unit_number': 'int',
        'bus_number': 'int',
        'adapter_type': 'str'
    }

    attribute_map = {
        'device_id': 'deviceId',
        'media_image': 'mediaImage',
        'media_type': 'mediaType',
        'media_state': 'mediaState',
        'unit_number': 'unitNumber',
        'bus_number': 'busNumber',
        'adapter_type': 'adapterType'
    }

    def __init__(self, device_id=None,media_image=None,media_type=None,media_state=None,unit_number=None,bus_number=None,adapter_type=None):
        self._device_id = None
        self._media_image = None
        self._media_type = None
        self._media_state = None
        self._unit_number = None
        self._bus_number = None
        self._adapter_type = None

        if device_id is not None:
            self.device_id = device_id
        if media_image is not None:
            self.media_image = media_image
        if media_type is not None:
            self.media_type = media_type
        if media_state is not None:
            self.media_state = media_state
        if unit_number is not None:
            self.unit_number = unit_number
        if bus_number is not None:
            self.bus_number = bus_number
        if adapter_type is not None:
            self.adapter_type = adapter_type

    @property
    def device_id(self):
        return self._device_id
    
    @device_id.setter
    def device_id(self, device_id):
        self._device_id = device_id

    @property
    def media_image(self):
        return self._media_image
    
    @media_image.setter
    def media_image(self, media_image):
        self._media_image = media_image

    @property
    def media_type(self):
        return self._media_type
    
    @media_type.setter
    def media_type(self, media_type):
        self._media_type = media_type

    @property
    def media_state(self):
        return self._media_state
    
    @media_state.setter
    def media_state(self, media_state):
        self._media_state = media_state

    @property
    def unit_number(self):
        return self._unit_number
    
    @unit_number.setter
    def unit_number(self, unit_number):
        self._unit_number = unit_number

    @property
    def bus_number(self):
        return self._bus_number
    
    @bus_number.setter
    def bus_number(self, bus_number):
        self._bus_number = bus_number

    @property
    def adapter_type(self):
        return self._adapter_type
    
    @adapter_type.setter
    def adapter_type(self, adapter_type):
        self._adapter_type = adapter_type


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, MediaSettingsType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
