"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from ..schema.ovf.section_type import SectionType


class LeaseSettingsSectionType(SectionType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'link': 'list[LinkType]',
        'deployment_lease_in_seconds': 'int',
        'storage_lease_in_seconds': 'int',
        'deployment_lease_expiration': 'str',
        'storage_lease_expiration': 'str',
        'any': 'list[object]',
        'href': 'str',
        'type': 'str'
    }

    attribute_map = {
        'link': 'link',
        'deployment_lease_in_seconds': 'deploymentLeaseInSeconds',
        'storage_lease_in_seconds': 'storageLeaseInSeconds',
        'deployment_lease_expiration': 'deploymentLeaseExpiration',
        'storage_lease_expiration': 'storageLeaseExpiration',
        'any': 'any',
        'href': 'href',
        'type': 'type'
    }

    def __init__(self, link=None,deployment_lease_in_seconds=None,storage_lease_in_seconds=None,deployment_lease_expiration=None,storage_lease_expiration=None,any=None,href=None,type=None):
        self._link = None
        self._deployment_lease_in_seconds = None
        self._storage_lease_in_seconds = None
        self._deployment_lease_expiration = None
        self._storage_lease_expiration = None
        self._any = None
        self._href = None
        self._type = None

        if link is not None:
            self.link = link
        if deployment_lease_in_seconds is not None:
            self.deployment_lease_in_seconds = deployment_lease_in_seconds
        if storage_lease_in_seconds is not None:
            self.storage_lease_in_seconds = storage_lease_in_seconds
        if deployment_lease_expiration is not None:
            self.deployment_lease_expiration = deployment_lease_expiration
        if storage_lease_expiration is not None:
            self.storage_lease_expiration = storage_lease_expiration
        if any is not None:
            self.any = any
        if href is not None:
            self.href = href
        if type is not None:
            self.type = type

    @property
    def link(self):
        return self._link
    
    @link.setter
    def link(self, link):
        self._link = link

    @property
    def deployment_lease_in_seconds(self):
        return self._deployment_lease_in_seconds
    
    @deployment_lease_in_seconds.setter
    def deployment_lease_in_seconds(self, deployment_lease_in_seconds):
        self._deployment_lease_in_seconds = deployment_lease_in_seconds

    @property
    def storage_lease_in_seconds(self):
        return self._storage_lease_in_seconds
    
    @storage_lease_in_seconds.setter
    def storage_lease_in_seconds(self, storage_lease_in_seconds):
        self._storage_lease_in_seconds = storage_lease_in_seconds

    @property
    def deployment_lease_expiration(self):
        return self._deployment_lease_expiration
    
    @deployment_lease_expiration.setter
    def deployment_lease_expiration(self, deployment_lease_expiration):
        self._deployment_lease_expiration = deployment_lease_expiration

    @property
    def storage_lease_expiration(self):
        return self._storage_lease_expiration
    
    @storage_lease_expiration.setter
    def storage_lease_expiration(self, storage_lease_expiration):
        self._storage_lease_expiration = storage_lease_expiration

    @property
    def any(self):
        return self._any
    
    @any.setter
    def any(self, any):
        self._any = any

    @property
    def href(self):
        return self._href
    
    @href.setter
    def href(self, href):
        self._href = href

    @property
    def type(self):
        return self._type
    
    @type.setter
    def type(self, type):
        self._type = type


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, LeaseSettingsSectionType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
