"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .ipsec_vpn_managed_peer_type import IpsecVpnManagedPeerType


class IpsecVpnRemotePeerType(IpsecVpnManagedPeerType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'vcd_url': 'str',
        'vcd_organization': 'str',
        'vcd_username': 'str'
    }

    attribute_map = {
        'vcd_url': 'vcdUrl',
        'vcd_organization': 'vcdOrganization',
        'vcd_username': 'vcdUsername'
    }

    def __init__(self, vcd_url=None,vcd_organization=None,vcd_username=None):
        self._vcd_url = None
        self._vcd_organization = None
        self._vcd_username = None

        if vcd_url is not None:
            self.vcd_url = vcd_url
        if vcd_organization is not None:
            self.vcd_organization = vcd_organization
        if vcd_username is not None:
            self.vcd_username = vcd_username

    @property
    def vcd_url(self):
        return self._vcd_url
    
    @vcd_url.setter
    def vcd_url(self, vcd_url):
        self._vcd_url = vcd_url

    @property
    def vcd_organization(self):
        return self._vcd_organization
    
    @vcd_organization.setter
    def vcd_organization(self, vcd_organization):
        self._vcd_organization = vcd_organization

    @property
    def vcd_username(self):
        return self._vcd_username
    
    @vcd_username.setter
    def vcd_username(self, vcd_username):
        self._vcd_username = vcd_username


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, IpsecVpnRemotePeerType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
