"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .params_type import ParamsType


class InstantiateVmTemplateParamsType(ParamsType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'sourced_vm_template_item': 'SourcedVmTemplateParamsType',
        'all_eul_as_accepted': 'bool',
        'compute_policy': 'ComputePolicyType',
        'power_on': 'bool'
    }

    attribute_map = {
        'sourced_vm_template_item': 'sourcedVmTemplateItem',
        'all_eul_as_accepted': 'allEULAsAccepted',
        'compute_policy': 'computePolicy',
        'power_on': 'powerOn'
    }

    def __init__(self, sourced_vm_template_item=None,all_eul_as_accepted=None,compute_policy=None,power_on=None):
        self._sourced_vm_template_item = None
        self._all_eul_as_accepted = None
        self._compute_policy = None
        self._power_on = None

        if sourced_vm_template_item is not None:
            self.sourced_vm_template_item = sourced_vm_template_item
        if all_eul_as_accepted is not None:
            self.all_eul_as_accepted = all_eul_as_accepted
        if compute_policy is not None:
            self.compute_policy = compute_policy
        if power_on is not None:
            self.power_on = power_on

    @property
    def sourced_vm_template_item(self):
        return self._sourced_vm_template_item
    
    @sourced_vm_template_item.setter
    def sourced_vm_template_item(self, sourced_vm_template_item):
        self._sourced_vm_template_item = sourced_vm_template_item

    @property
    def all_eul_as_accepted(self):
        return self._all_eul_as_accepted
    
    @all_eul_as_accepted.setter
    def all_eul_as_accepted(self, all_eul_as_accepted):
        self._all_eul_as_accepted = all_eul_as_accepted

    @property
    def compute_policy(self):
        return self._compute_policy
    
    @compute_policy.setter
    def compute_policy(self, compute_policy):
        self._compute_policy = compute_policy

    @property
    def power_on(self):
        return self._power_on
    
    @power_on.setter
    def power_on(self, power_on):
        self._power_on = power_on


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, InstantiateVmTemplateParamsType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
