"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .v_cloud_extensible_type import VCloudExtensibleType


class InstantiateVmHardwareCustomizationParamsType(VCloudExtensibleType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'number_of_cpus': 'int',
        'cores_per_socket': 'int',
        'memory_size': 'int',
        'disk': 'list[Disk]'
    }

    attribute_map = {
        'number_of_cpus': 'numberOfCpus',
        'cores_per_socket': 'coresPerSocket',
        'memory_size': 'memorySize',
        'disk': 'disk'
    }

    def __init__(self, number_of_cpus=None,cores_per_socket=None,memory_size=None,disk=None):
        self._number_of_cpus = None
        self._cores_per_socket = None
        self._memory_size = None
        self._disk = None

        if number_of_cpus is not None:
            self.number_of_cpus = number_of_cpus
        if cores_per_socket is not None:
            self.cores_per_socket = cores_per_socket
        if memory_size is not None:
            self.memory_size = memory_size
        if disk is not None:
            self.disk = disk

    @property
    def number_of_cpus(self):
        return self._number_of_cpus
    
    @number_of_cpus.setter
    def number_of_cpus(self, number_of_cpus):
        self._number_of_cpus = number_of_cpus

    @property
    def cores_per_socket(self):
        return self._cores_per_socket
    
    @cores_per_socket.setter
    def cores_per_socket(self, cores_per_socket):
        self._cores_per_socket = cores_per_socket

    @property
    def memory_size(self):
        return self._memory_size
    
    @memory_size.setter
    def memory_size(self, memory_size):
        self._memory_size = memory_size

    @property
    def disk(self):
        return self._disk
    
    @disk.setter
    def disk(self, disk):
        self._disk = disk


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, InstantiateVmHardwareCustomizationParamsType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
