"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .v_app_creation_params_type import VAppCreationParamsType


class InstantiateOvfParamsType(VAppCreationParamsType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'all_eul_as_accepted': 'bool',
        'remove_non_standard_ovf_extensions': 'bool',
        'network_mapping': 'list[NetworkMappingType]',
        'instantiate_ovf_property': 'list[InstantiateOvfPropertyType]',
        'instantiate_vm_params': 'list[InstantiateVmParamsType]',
        'transfer_format': 'str'
    }

    attribute_map = {
        'all_eul_as_accepted': 'allEULAsAccepted',
        'remove_non_standard_ovf_extensions': 'removeNonStandardOvfExtensions',
        'network_mapping': 'networkMapping',
        'instantiate_ovf_property': 'instantiateOvfProperty',
        'instantiate_vm_params': 'instantiateVmParams',
        'transfer_format': 'transferFormat'
    }

    def __init__(self, all_eul_as_accepted=None,remove_non_standard_ovf_extensions=None,network_mapping=None,instantiate_ovf_property=None,instantiate_vm_params=None,transfer_format=None):
        self._all_eul_as_accepted = None
        self._remove_non_standard_ovf_extensions = None
        self._network_mapping = None
        self._instantiate_ovf_property = None
        self._instantiate_vm_params = None
        self._transfer_format = None

        if all_eul_as_accepted is not None:
            self.all_eul_as_accepted = all_eul_as_accepted
        if remove_non_standard_ovf_extensions is not None:
            self.remove_non_standard_ovf_extensions = remove_non_standard_ovf_extensions
        if network_mapping is not None:
            self.network_mapping = network_mapping
        if instantiate_ovf_property is not None:
            self.instantiate_ovf_property = instantiate_ovf_property
        if instantiate_vm_params is not None:
            self.instantiate_vm_params = instantiate_vm_params
        if transfer_format is not None:
            self.transfer_format = transfer_format

    @property
    def all_eul_as_accepted(self):
        return self._all_eul_as_accepted
    
    @all_eul_as_accepted.setter
    def all_eul_as_accepted(self, all_eul_as_accepted):
        self._all_eul_as_accepted = all_eul_as_accepted

    @property
    def remove_non_standard_ovf_extensions(self):
        return self._remove_non_standard_ovf_extensions
    
    @remove_non_standard_ovf_extensions.setter
    def remove_non_standard_ovf_extensions(self, remove_non_standard_ovf_extensions):
        self._remove_non_standard_ovf_extensions = remove_non_standard_ovf_extensions

    @property
    def network_mapping(self):
        return self._network_mapping
    
    @network_mapping.setter
    def network_mapping(self, network_mapping):
        self._network_mapping = network_mapping

    @property
    def instantiate_ovf_property(self):
        return self._instantiate_ovf_property
    
    @instantiate_ovf_property.setter
    def instantiate_ovf_property(self, instantiate_ovf_property):
        self._instantiate_ovf_property = instantiate_ovf_property

    @property
    def instantiate_vm_params(self):
        return self._instantiate_vm_params
    
    @instantiate_vm_params.setter
    def instantiate_vm_params(self, instantiate_vm_params):
        self._instantiate_vm_params = instantiate_vm_params

    @property
    def transfer_format(self):
        return self._transfer_format
    
    @transfer_format.setter
    def transfer_format(self, transfer_format):
        self._transfer_format = transfer_format


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, InstantiateOvfParamsType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
