"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .entity_type import EntityType


class GroupType(EntityType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name_in_source': 'str',
        'users_list': 'UsersListType',
        'provider_type': 'str',
        'role': 'ReferenceType'
    }

    attribute_map = {
        'name_in_source': 'nameInSource',
        'users_list': 'usersList',
        'provider_type': 'providerType',
        'role': 'role'
    }

    def __init__(self, name_in_source=None,users_list=None,provider_type=None,role=None):
        self._name_in_source = None
        self._users_list = None
        self._provider_type = None
        self._role = None

        if name_in_source is not None:
            self.name_in_source = name_in_source
        if users_list is not None:
            self.users_list = users_list
        if provider_type is not None:
            self.provider_type = provider_type
        if role is not None:
            self.role = role

    @property
    def name_in_source(self):
        return self._name_in_source
    
    @name_in_source.setter
    def name_in_source(self, name_in_source):
        self._name_in_source = name_in_source

    @property
    def users_list(self):
        return self._users_list
    
    @users_list.setter
    def users_list(self, users_list):
        self._users_list = users_list

    @property
    def provider_type(self):
        return self._provider_type
    
    @provider_type.setter
    def provider_type(self, provider_type):
        self._provider_type = provider_type

    @property
    def role(self):
        return self._role
    
    @role.setter
    def role(self, role):
        self._role = role


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, GroupType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
