"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .entity_type import EntityType


class GatewayType(EntityType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'gateway_backing_ref': 'GatewayBackingRefType',
        'edge_gateway_type': 'EdgeGatewayType',
        'configuration': 'GatewayConfigurationType',
        'status': 'int'
    }

    attribute_map = {
        'gateway_backing_ref': 'gatewayBackingRef',
        'edge_gateway_type': 'edgeGatewayType',
        'configuration': 'configuration',
        'status': 'status'
    }

    def __init__(self, gateway_backing_ref=None,edge_gateway_type=None,configuration=None,status=None):
        self._gateway_backing_ref = None
        self._edge_gateway_type = None
        self._configuration = None
        self._status = None

        if gateway_backing_ref is not None:
            self.gateway_backing_ref = gateway_backing_ref
        if edge_gateway_type is not None:
            self.edge_gateway_type = edge_gateway_type
        if configuration is not None:
            self.configuration = configuration
        if status is not None:
            self.status = status

    @property
    def gateway_backing_ref(self):
        return self._gateway_backing_ref
    
    @gateway_backing_ref.setter
    def gateway_backing_ref(self, gateway_backing_ref):
        self._gateway_backing_ref = gateway_backing_ref

    @property
    def edge_gateway_type(self):
        return self._edge_gateway_type
    
    @edge_gateway_type.setter
    def edge_gateway_type(self, edge_gateway_type):
        self._edge_gateway_type = edge_gateway_type

    @property
    def configuration(self):
        return self._configuration
    
    @configuration.setter
    def configuration(self, configuration):
        self._configuration = configuration

    @property
    def status(self):
        return self._status
    
    @status.setter
    def status(self, status):
        self._status = status


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, GatewayType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
