"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .v_cloud_extensible_type import VCloudExtensibleType


class GatewayConfigurationType(VCloudExtensibleType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'backward_compatibility_mode': 'bool',
        'gateway_backing_config': 'str',
        'gateway_interfaces': 'GatewayInterfacesType',
        'edge_gateway_service_configuration': 'GatewayFeaturesType',
        'ha_enabled': 'bool',
        'use_default_route_for_dns_relay': 'bool',
        'syslog_server_settings': 'SyslogServerType',
        'advanced_networking_enabled': 'bool',
        'distributed_routing_enabled': 'bool',
        'fips_mode_enabled': 'bool',
        'edge_cluster_configuration': 'EdgeClusterConfigurationType'
    }

    attribute_map = {
        'backward_compatibility_mode': 'backwardCompatibilityMode',
        'gateway_backing_config': 'gatewayBackingConfig',
        'gateway_interfaces': 'gatewayInterfaces',
        'edge_gateway_service_configuration': 'edgeGatewayServiceConfiguration',
        'ha_enabled': 'haEnabled',
        'use_default_route_for_dns_relay': 'useDefaultRouteForDnsRelay',
        'syslog_server_settings': 'syslogServerSettings',
        'advanced_networking_enabled': 'advancedNetworkingEnabled',
        'distributed_routing_enabled': 'distributedRoutingEnabled',
        'fips_mode_enabled': 'fipsModeEnabled',
        'edge_cluster_configuration': 'edgeClusterConfiguration'
    }

    def __init__(self, backward_compatibility_mode=None,gateway_backing_config=None,gateway_interfaces=None,edge_gateway_service_configuration=None,ha_enabled=None,use_default_route_for_dns_relay=None,syslog_server_settings=None,advanced_networking_enabled=None,distributed_routing_enabled=None,fips_mode_enabled=None,edge_cluster_configuration=None):
        self._backward_compatibility_mode = None
        self._gateway_backing_config = None
        self._gateway_interfaces = None
        self._edge_gateway_service_configuration = None
        self._ha_enabled = None
        self._use_default_route_for_dns_relay = None
        self._syslog_server_settings = None
        self._advanced_networking_enabled = None
        self._distributed_routing_enabled = None
        self._fips_mode_enabled = None
        self._edge_cluster_configuration = None

        if backward_compatibility_mode is not None:
            self.backward_compatibility_mode = backward_compatibility_mode
        if gateway_backing_config is not None:
            self.gateway_backing_config = gateway_backing_config
        if gateway_interfaces is not None:
            self.gateway_interfaces = gateway_interfaces
        if edge_gateway_service_configuration is not None:
            self.edge_gateway_service_configuration = edge_gateway_service_configuration
        if ha_enabled is not None:
            self.ha_enabled = ha_enabled
        if use_default_route_for_dns_relay is not None:
            self.use_default_route_for_dns_relay = use_default_route_for_dns_relay
        if syslog_server_settings is not None:
            self.syslog_server_settings = syslog_server_settings
        if advanced_networking_enabled is not None:
            self.advanced_networking_enabled = advanced_networking_enabled
        if distributed_routing_enabled is not None:
            self.distributed_routing_enabled = distributed_routing_enabled
        if fips_mode_enabled is not None:
            self.fips_mode_enabled = fips_mode_enabled
        if edge_cluster_configuration is not None:
            self.edge_cluster_configuration = edge_cluster_configuration

    @property
    def backward_compatibility_mode(self):
        return self._backward_compatibility_mode
    
    @backward_compatibility_mode.setter
    def backward_compatibility_mode(self, backward_compatibility_mode):
        self._backward_compatibility_mode = backward_compatibility_mode

    @property
    def gateway_backing_config(self):
        return self._gateway_backing_config
    
    @gateway_backing_config.setter
    def gateway_backing_config(self, gateway_backing_config):
        self._gateway_backing_config = gateway_backing_config

    @property
    def gateway_interfaces(self):
        return self._gateway_interfaces
    
    @gateway_interfaces.setter
    def gateway_interfaces(self, gateway_interfaces):
        self._gateway_interfaces = gateway_interfaces

    @property
    def edge_gateway_service_configuration(self):
        return self._edge_gateway_service_configuration
    
    @edge_gateway_service_configuration.setter
    def edge_gateway_service_configuration(self, edge_gateway_service_configuration):
        self._edge_gateway_service_configuration = edge_gateway_service_configuration

    @property
    def ha_enabled(self):
        return self._ha_enabled
    
    @ha_enabled.setter
    def ha_enabled(self, ha_enabled):
        self._ha_enabled = ha_enabled

    @property
    def use_default_route_for_dns_relay(self):
        return self._use_default_route_for_dns_relay
    
    @use_default_route_for_dns_relay.setter
    def use_default_route_for_dns_relay(self, use_default_route_for_dns_relay):
        self._use_default_route_for_dns_relay = use_default_route_for_dns_relay

    @property
    def syslog_server_settings(self):
        return self._syslog_server_settings
    
    @syslog_server_settings.setter
    def syslog_server_settings(self, syslog_server_settings):
        self._syslog_server_settings = syslog_server_settings

    @property
    def advanced_networking_enabled(self):
        return self._advanced_networking_enabled
    
    @advanced_networking_enabled.setter
    def advanced_networking_enabled(self, advanced_networking_enabled):
        self._advanced_networking_enabled = advanced_networking_enabled

    @property
    def distributed_routing_enabled(self):
        return self._distributed_routing_enabled
    
    @distributed_routing_enabled.setter
    def distributed_routing_enabled(self, distributed_routing_enabled):
        self._distributed_routing_enabled = distributed_routing_enabled

    @property
    def fips_mode_enabled(self):
        return self._fips_mode_enabled
    
    @fips_mode_enabled.setter
    def fips_mode_enabled(self, fips_mode_enabled):
        self._fips_mode_enabled = fips_mode_enabled

    @property
    def edge_cluster_configuration(self):
        return self._edge_cluster_configuration
    
    @edge_cluster_configuration.setter
    def edge_cluster_configuration(self, edge_cluster_configuration):
        self._edge_cluster_configuration = edge_cluster_configuration


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, GatewayConfigurationType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
