"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .network_service_type import NetworkServiceType


class FirewallServiceType(NetworkServiceType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'default_action': 'str',
        'log_default_action': 'bool',
        'firewall_rule': 'list[FirewallRuleType]'
    }

    attribute_map = {
        'default_action': 'defaultAction',
        'log_default_action': 'logDefaultAction',
        'firewall_rule': 'firewallRule'
    }

    def __init__(self, default_action=None,log_default_action=None,firewall_rule=None):
        self._default_action = None
        self._log_default_action = None
        self._firewall_rule = None

        if default_action is not None:
            self.default_action = default_action
        if log_default_action is not None:
            self.log_default_action = log_default_action
        if firewall_rule is not None:
            self.firewall_rule = firewall_rule

    @property
    def default_action(self):
        return self._default_action
    
    @default_action.setter
    def default_action(self, default_action):
        self._default_action = default_action

    @property
    def log_default_action(self):
        return self._log_default_action
    
    @log_default_action.setter
    def log_default_action(self, log_default_action):
        self._log_default_action = log_default_action

    @property
    def firewall_rule(self):
        return self._firewall_rule
    
    @firewall_rule.setter
    def firewall_rule(self, firewall_rule):
        self._firewall_rule = firewall_rule


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, FirewallServiceType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
