"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .v_cloud_extensible_type import VCloudExtensibleType


class ExternalSubjectType(VCloudExtensibleType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'subject_id': 'str',
        'is_user': 'bool',
        'idp_type': 'str'
    }

    attribute_map = {
        'subject_id': 'subjectId',
        'is_user': 'isUser',
        'idp_type': 'idpType'
    }

    def __init__(self, subject_id=None,is_user=None,idp_type=None):
        self._subject_id = None
        self._is_user = None
        self._idp_type = None

        if subject_id is not None:
            self.subject_id = subject_id
        if is_user is not None:
            self.is_user = is_user
        if idp_type is not None:
            self.idp_type = idp_type

    @property
    def subject_id(self):
        return self._subject_id
    
    @subject_id.setter
    def subject_id(self, subject_id):
        self._subject_id = subject_id

    @property
    def is_user(self):
        return self._is_user
    
    @is_user.setter
    def is_user(self, is_user):
        self._is_user = is_user

    @property
    def idp_type(self):
        return self._idp_type
    
    @idp_type.setter
    def idp_type(self, idp_type):
        self._idp_type = idp_type


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ExternalSubjectType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
