"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re


class VMWVdcTemplateSpecificationType(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'nic_quota': 'int',
        'vm_quota': 'int',
        'provisioned_network_quota': 'int',
        'gateway_configuration': 'VdcTemplateSpecificationGatewayConfigurationType',
        'storage_profile': 'list[VdcStorageProfileType]',
        'is_elastic': 'bool',
        'include_memory_overhead': 'bool',
        'thin_provision': 'bool',
        'fast_provisioning_enabled': 'bool',
        'network_pool_reference': 'ReferenceType',
        'automatic_network_pool_reference': 'AutomaticNetworkPoolReferenceType',
        'network_profile_configuration': 'VdcTemplateNetworkProfileType'
    }

    attribute_map = {
        'nic_quota': 'nicQuota',
        'vm_quota': 'vmQuota',
        'provisioned_network_quota': 'provisionedNetworkQuota',
        'gateway_configuration': 'gatewayConfiguration',
        'storage_profile': 'storageProfile',
        'is_elastic': 'isElastic',
        'include_memory_overhead': 'includeMemoryOverhead',
        'thin_provision': 'thinProvision',
        'fast_provisioning_enabled': 'fastProvisioningEnabled',
        'network_pool_reference': 'networkPoolReference',
        'automatic_network_pool_reference': 'automaticNetworkPoolReference',
        'network_profile_configuration': 'networkProfileConfiguration'
    }

    def __init__(self, nic_quota=None,vm_quota=None,provisioned_network_quota=None,gateway_configuration=None,storage_profile=None,is_elastic=None,include_memory_overhead=None,thin_provision=None,fast_provisioning_enabled=None,network_pool_reference=None,automatic_network_pool_reference=None,network_profile_configuration=None):
        self._nic_quota = None
        self._vm_quota = None
        self._provisioned_network_quota = None
        self._gateway_configuration = None
        self._storage_profile = None
        self._is_elastic = None
        self._include_memory_overhead = None
        self._thin_provision = None
        self._fast_provisioning_enabled = None
        self._network_pool_reference = None
        self._automatic_network_pool_reference = None
        self._network_profile_configuration = None

        if nic_quota is not None:
            self.nic_quota = nic_quota
        if vm_quota is not None:
            self.vm_quota = vm_quota
        if provisioned_network_quota is not None:
            self.provisioned_network_quota = provisioned_network_quota
        if gateway_configuration is not None:
            self.gateway_configuration = gateway_configuration
        if storage_profile is not None:
            self.storage_profile = storage_profile
        if is_elastic is not None:
            self.is_elastic = is_elastic
        if include_memory_overhead is not None:
            self.include_memory_overhead = include_memory_overhead
        if thin_provision is not None:
            self.thin_provision = thin_provision
        if fast_provisioning_enabled is not None:
            self.fast_provisioning_enabled = fast_provisioning_enabled
        if network_pool_reference is not None:
            self.network_pool_reference = network_pool_reference
        if automatic_network_pool_reference is not None:
            self.automatic_network_pool_reference = automatic_network_pool_reference
        if network_profile_configuration is not None:
            self.network_profile_configuration = network_profile_configuration

    @property
    def nic_quota(self):
        return self._nic_quota
    
    @nic_quota.setter
    def nic_quota(self, nic_quota):
        self._nic_quota = nic_quota

    @property
    def vm_quota(self):
        return self._vm_quota
    
    @vm_quota.setter
    def vm_quota(self, vm_quota):
        self._vm_quota = vm_quota

    @property
    def provisioned_network_quota(self):
        return self._provisioned_network_quota
    
    @provisioned_network_quota.setter
    def provisioned_network_quota(self, provisioned_network_quota):
        self._provisioned_network_quota = provisioned_network_quota

    @property
    def gateway_configuration(self):
        return self._gateway_configuration
    
    @gateway_configuration.setter
    def gateway_configuration(self, gateway_configuration):
        self._gateway_configuration = gateway_configuration

    @property
    def storage_profile(self):
        return self._storage_profile
    
    @storage_profile.setter
    def storage_profile(self, storage_profile):
        self._storage_profile = storage_profile

    @property
    def is_elastic(self):
        return self._is_elastic
    
    @is_elastic.setter
    def is_elastic(self, is_elastic):
        self._is_elastic = is_elastic

    @property
    def include_memory_overhead(self):
        return self._include_memory_overhead
    
    @include_memory_overhead.setter
    def include_memory_overhead(self, include_memory_overhead):
        self._include_memory_overhead = include_memory_overhead

    @property
    def thin_provision(self):
        return self._thin_provision
    
    @thin_provision.setter
    def thin_provision(self, thin_provision):
        self._thin_provision = thin_provision

    @property
    def fast_provisioning_enabled(self):
        return self._fast_provisioning_enabled
    
    @fast_provisioning_enabled.setter
    def fast_provisioning_enabled(self, fast_provisioning_enabled):
        self._fast_provisioning_enabled = fast_provisioning_enabled

    @property
    def network_pool_reference(self):
        return self._network_pool_reference
    
    @network_pool_reference.setter
    def network_pool_reference(self, network_pool_reference):
        self._network_pool_reference = network_pool_reference

    @property
    def automatic_network_pool_reference(self):
        return self._automatic_network_pool_reference
    
    @automatic_network_pool_reference.setter
    def automatic_network_pool_reference(self, automatic_network_pool_reference):
        self._automatic_network_pool_reference = automatic_network_pool_reference

    @property
    def network_profile_configuration(self):
        return self._network_profile_configuration
    
    @network_profile_configuration.setter
    def network_profile_configuration(self, network_profile_configuration):
        self._network_profile_configuration = network_profile_configuration


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VMWVdcTemplateSpecificationType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
