"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from ..resource_type import ResourceType


class VMWProviderVdcResourcePoolType(ResourceType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'resource_pool_vim_object_ref': 'VimObjectRefType',
        'resource_pool_ref': 'ReferenceType',
        'enabled': 'bool',
        'cpu_reservation_used': 'int',
        'cpu_max_usage': 'int',
        'mem_reservation_used': 'int',
        'mem_max_usage': 'int',
        'primary': 'bool'
    }

    attribute_map = {
        'resource_pool_vim_object_ref': 'resourcePoolVimObjectRef',
        'resource_pool_ref': 'resourcePoolRef',
        'enabled': 'enabled',
        'cpu_reservation_used': 'cpuReservationUsed',
        'cpu_max_usage': 'cpuMaxUsage',
        'mem_reservation_used': 'memReservationUsed',
        'mem_max_usage': 'memMaxUsage',
        'primary': 'primary'
    }

    def __init__(self, resource_pool_vim_object_ref=None,resource_pool_ref=None,enabled=None,cpu_reservation_used=None,cpu_max_usage=None,mem_reservation_used=None,mem_max_usage=None,primary=None):
        self._resource_pool_vim_object_ref = None
        self._resource_pool_ref = None
        self._enabled = None
        self._cpu_reservation_used = None
        self._cpu_max_usage = None
        self._mem_reservation_used = None
        self._mem_max_usage = None
        self._primary = None

        if resource_pool_vim_object_ref is not None:
            self.resource_pool_vim_object_ref = resource_pool_vim_object_ref
        if resource_pool_ref is not None:
            self.resource_pool_ref = resource_pool_ref
        if enabled is not None:
            self.enabled = enabled
        if cpu_reservation_used is not None:
            self.cpu_reservation_used = cpu_reservation_used
        if cpu_max_usage is not None:
            self.cpu_max_usage = cpu_max_usage
        if mem_reservation_used is not None:
            self.mem_reservation_used = mem_reservation_used
        if mem_max_usage is not None:
            self.mem_max_usage = mem_max_usage
        if primary is not None:
            self.primary = primary

    @property
    def resource_pool_vim_object_ref(self):
        return self._resource_pool_vim_object_ref
    
    @resource_pool_vim_object_ref.setter
    def resource_pool_vim_object_ref(self, resource_pool_vim_object_ref):
        self._resource_pool_vim_object_ref = resource_pool_vim_object_ref

    @property
    def resource_pool_ref(self):
        return self._resource_pool_ref
    
    @resource_pool_ref.setter
    def resource_pool_ref(self, resource_pool_ref):
        self._resource_pool_ref = resource_pool_ref

    @property
    def enabled(self):
        return self._enabled
    
    @enabled.setter
    def enabled(self, enabled):
        self._enabled = enabled

    @property
    def cpu_reservation_used(self):
        return self._cpu_reservation_used
    
    @cpu_reservation_used.setter
    def cpu_reservation_used(self, cpu_reservation_used):
        self._cpu_reservation_used = cpu_reservation_used

    @property
    def cpu_max_usage(self):
        return self._cpu_max_usage
    
    @cpu_max_usage.setter
    def cpu_max_usage(self, cpu_max_usage):
        self._cpu_max_usage = cpu_max_usage

    @property
    def mem_reservation_used(self):
        return self._mem_reservation_used
    
    @mem_reservation_used.setter
    def mem_reservation_used(self, mem_reservation_used):
        self._mem_reservation_used = mem_reservation_used

    @property
    def mem_max_usage(self):
        return self._mem_max_usage
    
    @mem_max_usage.setter
    def mem_max_usage(self, mem_max_usage):
        self._mem_max_usage = mem_max_usage

    @property
    def primary(self):
        return self._primary
    
    @primary.setter
    def primary(self, primary):
        self._primary = primary


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VMWProviderVdcResourcePoolType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
