"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .server_type import ServerType


class ShieldManagerType(ServerType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'network_provider_scope': 'str',
        'associated_vim_server': 'ReferenceType',
        'control_vm_resource_pool_vc_path': 'str',
        'control_vm_datastore_name': 'str',
        'control_vm_management_interface_name': 'str',
        'software_version': 'str'
    }

    attribute_map = {
        'network_provider_scope': 'networkProviderScope',
        'associated_vim_server': 'associatedVimServer',
        'control_vm_resource_pool_vc_path': 'controlVmResourcePoolVcPath',
        'control_vm_datastore_name': 'controlVmDatastoreName',
        'control_vm_management_interface_name': 'controlVmManagementInterfaceName',
        'software_version': 'softwareVersion'
    }

    def __init__(self, network_provider_scope=None,associated_vim_server=None,control_vm_resource_pool_vc_path=None,control_vm_datastore_name=None,control_vm_management_interface_name=None,software_version=None):
        self._network_provider_scope = None
        self._associated_vim_server = None
        self._control_vm_resource_pool_vc_path = None
        self._control_vm_datastore_name = None
        self._control_vm_management_interface_name = None
        self._software_version = None

        if network_provider_scope is not None:
            self.network_provider_scope = network_provider_scope
        if associated_vim_server is not None:
            self.associated_vim_server = associated_vim_server
        if control_vm_resource_pool_vc_path is not None:
            self.control_vm_resource_pool_vc_path = control_vm_resource_pool_vc_path
        if control_vm_datastore_name is not None:
            self.control_vm_datastore_name = control_vm_datastore_name
        if control_vm_management_interface_name is not None:
            self.control_vm_management_interface_name = control_vm_management_interface_name
        if software_version is not None:
            self.software_version = software_version

    @property
    def network_provider_scope(self):
        return self._network_provider_scope
    
    @network_provider_scope.setter
    def network_provider_scope(self, network_provider_scope):
        self._network_provider_scope = network_provider_scope

    @property
    def associated_vim_server(self):
        return self._associated_vim_server
    
    @associated_vim_server.setter
    def associated_vim_server(self, associated_vim_server):
        self._associated_vim_server = associated_vim_server

    @property
    def control_vm_resource_pool_vc_path(self):
        return self._control_vm_resource_pool_vc_path
    
    @control_vm_resource_pool_vc_path.setter
    def control_vm_resource_pool_vc_path(self, control_vm_resource_pool_vc_path):
        self._control_vm_resource_pool_vc_path = control_vm_resource_pool_vc_path

    @property
    def control_vm_datastore_name(self):
        return self._control_vm_datastore_name
    
    @control_vm_datastore_name.setter
    def control_vm_datastore_name(self, control_vm_datastore_name):
        self._control_vm_datastore_name = control_vm_datastore_name

    @property
    def control_vm_management_interface_name(self):
        return self._control_vm_management_interface_name
    
    @control_vm_management_interface_name.setter
    def control_vm_management_interface_name(self, control_vm_management_interface_name):
        self._control_vm_management_interface_name = control_vm_management_interface_name

    @property
    def software_version(self):
        return self._software_version
    
    @software_version.setter
    def software_version(self, software_version):
        self._software_version = software_version


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ShieldManagerType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
