"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from ..identifiable_resource_type import IdentifiableResourceType


class ObjectExtensionType(IdentifiableResourceType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'namespace': 'str',
        'enabled': 'bool',
        'exchange': 'str',
        'content_type': 'str',
        'vendor': 'str',
        'selectors': 'Selectors'
    }

    attribute_map = {
        'namespace': 'namespace',
        'enabled': 'enabled',
        'exchange': 'exchange',
        'content_type': 'contentType',
        'vendor': 'vendor',
        'selectors': 'selectors'
    }

    def __init__(self, namespace=None,enabled=None,exchange=None,content_type=None,vendor=None,selectors=None):
        self._namespace = None
        self._enabled = None
        self._exchange = None
        self._content_type = None
        self._vendor = None
        self._selectors = None

        if namespace is not None:
            self.namespace = namespace
        if enabled is not None:
            self.enabled = enabled
        if exchange is not None:
            self.exchange = exchange
        if content_type is not None:
            self.content_type = content_type
        if vendor is not None:
            self.vendor = vendor
        if selectors is not None:
            self.selectors = selectors

    @property
    def namespace(self):
        return self._namespace
    
    @namespace.setter
    def namespace(self, namespace):
        self._namespace = namespace

    @property
    def enabled(self):
        return self._enabled
    
    @enabled.setter
    def enabled(self, enabled):
        self._enabled = enabled

    @property
    def exchange(self):
        return self._exchange
    
    @exchange.setter
    def exchange(self, exchange):
        self._exchange = exchange

    @property
    def content_type(self):
        return self._content_type
    
    @content_type.setter
    def content_type(self, content_type):
        self._content_type = content_type

    @property
    def vendor(self):
        return self._vendor
    
    @vendor.setter
    def vendor(self, vendor):
        self._vendor = vendor

    @property
    def selectors(self):
        return self._selectors
    
    @selectors.setter
    def selectors(self, selectors):
        self._selectors = selectors


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ObjectExtensionType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
