"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from ..resource_type import ResourceType


class LicensingReportType(ResourceType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'sample': 'list[LicensingReportSampleType]',
        'product_serial_number': 'str',
        'report_date': 'str',
        'signature': 'str'
    }

    attribute_map = {
        'sample': 'sample',
        'product_serial_number': 'productSerialNumber',
        'report_date': 'reportDate',
        'signature': 'signature'
    }

    def __init__(self, sample=None,product_serial_number=None,report_date=None,signature=None):
        self._sample = None
        self._product_serial_number = None
        self._report_date = None
        self._signature = None

        if sample is not None:
            self.sample = sample
        if product_serial_number is not None:
            self.product_serial_number = product_serial_number
        if report_date is not None:
            self.report_date = report_date
        if signature is not None:
            self.signature = signature

    @property
    def sample(self):
        return self._sample
    
    @sample.setter
    def sample(self, sample):
        self._sample = sample

    @property
    def product_serial_number(self):
        return self._product_serial_number
    
    @product_serial_number.setter
    def product_serial_number(self, product_serial_number):
        self._product_serial_number = product_serial_number

    @property
    def report_date(self):
        return self._report_date
    
    @report_date.setter
    def report_date(self, report_date):
        self._report_date = report_date

    @property
    def signature(self):
        return self._signature
    
    @signature.setter
    def signature(self, signature):
        self._signature = signature


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, LicensingReportType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
