"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from ..resource_type import ResourceType


class LicenseMetricsInfoType(ResourceType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'vram': 'int',
        'vcpu': 'int',
        'running_v_ms': 'int',
        'physical_memory_used': 'int',
        'physical_socket_count': 'int',
        'available_physical_memory': 'int',
        'last_update': 'str',
        'publishing_to_remote_sites': 'bool',
        'subscribing_to_remote_sites': 'bool'
    }

    attribute_map = {
        'vram': 'vram',
        'vcpu': 'vcpu',
        'running_v_ms': 'runningVMs',
        'physical_memory_used': 'physicalMemoryUsed',
        'physical_socket_count': 'physicalSocketCount',
        'available_physical_memory': 'availablePhysicalMemory',
        'last_update': 'lastUpdate',
        'publishing_to_remote_sites': 'publishingToRemoteSites',
        'subscribing_to_remote_sites': 'subscribingToRemoteSites'
    }

    def __init__(self, vram=None,vcpu=None,running_v_ms=None,physical_memory_used=None,physical_socket_count=None,available_physical_memory=None,last_update=None,publishing_to_remote_sites=None,subscribing_to_remote_sites=None):
        self._vram = None
        self._vcpu = None
        self._running_v_ms = None
        self._physical_memory_used = None
        self._physical_socket_count = None
        self._available_physical_memory = None
        self._last_update = None
        self._publishing_to_remote_sites = None
        self._subscribing_to_remote_sites = None

        if vram is not None:
            self.vram = vram
        if vcpu is not None:
            self.vcpu = vcpu
        if running_v_ms is not None:
            self.running_v_ms = running_v_ms
        if physical_memory_used is not None:
            self.physical_memory_used = physical_memory_used
        if physical_socket_count is not None:
            self.physical_socket_count = physical_socket_count
        if available_physical_memory is not None:
            self.available_physical_memory = available_physical_memory
        if last_update is not None:
            self.last_update = last_update
        if publishing_to_remote_sites is not None:
            self.publishing_to_remote_sites = publishing_to_remote_sites
        if subscribing_to_remote_sites is not None:
            self.subscribing_to_remote_sites = subscribing_to_remote_sites

    @property
    def vram(self):
        return self._vram
    
    @vram.setter
    def vram(self, vram):
        self._vram = vram

    @property
    def vcpu(self):
        return self._vcpu
    
    @vcpu.setter
    def vcpu(self, vcpu):
        self._vcpu = vcpu

    @property
    def running_v_ms(self):
        return self._running_v_ms
    
    @running_v_ms.setter
    def running_v_ms(self, running_v_ms):
        self._running_v_ms = running_v_ms

    @property
    def physical_memory_used(self):
        return self._physical_memory_used
    
    @physical_memory_used.setter
    def physical_memory_used(self, physical_memory_used):
        self._physical_memory_used = physical_memory_used

    @property
    def physical_socket_count(self):
        return self._physical_socket_count
    
    @physical_socket_count.setter
    def physical_socket_count(self, physical_socket_count):
        self._physical_socket_count = physical_socket_count

    @property
    def available_physical_memory(self):
        return self._available_physical_memory
    
    @available_physical_memory.setter
    def available_physical_memory(self, available_physical_memory):
        self._available_physical_memory = available_physical_memory

    @property
    def last_update(self):
        return self._last_update
    
    @last_update.setter
    def last_update(self, last_update):
        self._last_update = last_update

    @property
    def publishing_to_remote_sites(self):
        return self._publishing_to_remote_sites
    
    @publishing_to_remote_sites.setter
    def publishing_to_remote_sites(self, publishing_to_remote_sites):
        self._publishing_to_remote_sites = publishing_to_remote_sites

    @property
    def subscribing_to_remote_sites(self):
        return self._subscribing_to_remote_sites
    
    @subscribing_to_remote_sites.setter
    def subscribing_to_remote_sites(self, subscribing_to_remote_sites):
        self._subscribing_to_remote_sites = subscribing_to_remote_sites


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, LicenseMetricsInfoType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
