"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from ..resource_type import ResourceType


class LdapGroupAttributesType(ResourceType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'object_class': 'str',
        'object_identifier': 'str',
        'group_name': 'str',
        'membership': 'str',
        'membership_identifier': 'str',
        'back_link_identifier': 'str'
    }

    attribute_map = {
        'object_class': 'objectClass',
        'object_identifier': 'objectIdentifier',
        'group_name': 'groupName',
        'membership': 'membership',
        'membership_identifier': 'membershipIdentifier',
        'back_link_identifier': 'backLinkIdentifier'
    }

    def __init__(self, object_class=None,object_identifier=None,group_name=None,membership=None,membership_identifier=None,back_link_identifier=None):
        self._object_class = None
        self._object_identifier = None
        self._group_name = None
        self._membership = None
        self._membership_identifier = None
        self._back_link_identifier = None

        if object_class is not None:
            self.object_class = object_class
        if object_identifier is not None:
            self.object_identifier = object_identifier
        if group_name is not None:
            self.group_name = group_name
        if membership is not None:
            self.membership = membership
        if membership_identifier is not None:
            self.membership_identifier = membership_identifier
        if back_link_identifier is not None:
            self.back_link_identifier = back_link_identifier

    @property
    def object_class(self):
        return self._object_class
    
    @object_class.setter
    def object_class(self, object_class):
        self._object_class = object_class

    @property
    def object_identifier(self):
        return self._object_identifier
    
    @object_identifier.setter
    def object_identifier(self, object_identifier):
        self._object_identifier = object_identifier

    @property
    def group_name(self):
        return self._group_name
    
    @group_name.setter
    def group_name(self, group_name):
        self._group_name = group_name

    @property
    def membership(self):
        return self._membership
    
    @membership.setter
    def membership(self, membership):
        self._membership = membership

    @property
    def membership_identifier(self):
        return self._membership_identifier
    
    @membership_identifier.setter
    def membership_identifier(self, membership_identifier):
        self._membership_identifier = membership_identifier

    @property
    def back_link_identifier(self):
        return self._back_link_identifier
    
    @back_link_identifier.setter
    def back_link_identifier(self, back_link_identifier):
        self._back_link_identifier = back_link_identifier


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, LdapGroupAttributesType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
