"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from ..resource_type import ResourceType


class CpomSettingsType(ResourceType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'max_active_sddc_proxy_quota': 'int',
        'max_active_sddc_proxy_per_user_quota': 'int',
        'sddc_proxied_host_connection_timeout_seconds': 'int',
        'allow_vc_tenant_and_provider_scoped': 'bool',
        'allow_insecure_sddc_proxying': 'bool'
    }

    attribute_map = {
        'max_active_sddc_proxy_quota': 'maxActiveSddcProxyQuota',
        'max_active_sddc_proxy_per_user_quota': 'maxActiveSddcProxyPerUserQuota',
        'sddc_proxied_host_connection_timeout_seconds': 'sddcProxiedHostConnectionTimeoutSeconds',
        'allow_vc_tenant_and_provider_scoped': 'allowVcTenantAndProviderScoped',
        'allow_insecure_sddc_proxying': 'allowInsecureSddcProxying'
    }

    def __init__(self, max_active_sddc_proxy_quota=None,max_active_sddc_proxy_per_user_quota=None,sddc_proxied_host_connection_timeout_seconds=None,allow_vc_tenant_and_provider_scoped=None,allow_insecure_sddc_proxying=None):
        self._max_active_sddc_proxy_quota = None
        self._max_active_sddc_proxy_per_user_quota = None
        self._sddc_proxied_host_connection_timeout_seconds = None
        self._allow_vc_tenant_and_provider_scoped = None
        self._allow_insecure_sddc_proxying = None

        if max_active_sddc_proxy_quota is not None:
            self.max_active_sddc_proxy_quota = max_active_sddc_proxy_quota
        if max_active_sddc_proxy_per_user_quota is not None:
            self.max_active_sddc_proxy_per_user_quota = max_active_sddc_proxy_per_user_quota
        if sddc_proxied_host_connection_timeout_seconds is not None:
            self.sddc_proxied_host_connection_timeout_seconds = sddc_proxied_host_connection_timeout_seconds
        if allow_vc_tenant_and_provider_scoped is not None:
            self.allow_vc_tenant_and_provider_scoped = allow_vc_tenant_and_provider_scoped
        if allow_insecure_sddc_proxying is not None:
            self.allow_insecure_sddc_proxying = allow_insecure_sddc_proxying

    @property
    def max_active_sddc_proxy_quota(self):
        return self._max_active_sddc_proxy_quota
    
    @max_active_sddc_proxy_quota.setter
    def max_active_sddc_proxy_quota(self, max_active_sddc_proxy_quota):
        self._max_active_sddc_proxy_quota = max_active_sddc_proxy_quota

    @property
    def max_active_sddc_proxy_per_user_quota(self):
        return self._max_active_sddc_proxy_per_user_quota
    
    @max_active_sddc_proxy_per_user_quota.setter
    def max_active_sddc_proxy_per_user_quota(self, max_active_sddc_proxy_per_user_quota):
        self._max_active_sddc_proxy_per_user_quota = max_active_sddc_proxy_per_user_quota

    @property
    def sddc_proxied_host_connection_timeout_seconds(self):
        return self._sddc_proxied_host_connection_timeout_seconds
    
    @sddc_proxied_host_connection_timeout_seconds.setter
    def sddc_proxied_host_connection_timeout_seconds(self, sddc_proxied_host_connection_timeout_seconds):
        self._sddc_proxied_host_connection_timeout_seconds = sddc_proxied_host_connection_timeout_seconds

    @property
    def allow_vc_tenant_and_provider_scoped(self):
        return self._allow_vc_tenant_and_provider_scoped
    
    @allow_vc_tenant_and_provider_scoped.setter
    def allow_vc_tenant_and_provider_scoped(self, allow_vc_tenant_and_provider_scoped):
        self._allow_vc_tenant_and_provider_scoped = allow_vc_tenant_and_provider_scoped

    @property
    def allow_insecure_sddc_proxying(self):
        return self._allow_insecure_sddc_proxying
    
    @allow_insecure_sddc_proxying.setter
    def allow_insecure_sddc_proxying(self, allow_insecure_sddc_proxying):
        self._allow_insecure_sddc_proxying = allow_insecure_sddc_proxying


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CpomSettingsType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
