"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from ..identifiable_resource_type import IdentifiableResourceType


class ApiFilterType(IdentifiableResourceType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'url_pattern': 'str',
        'response_content_type': 'str'
    }

    attribute_map = {
        'url_pattern': 'urlPattern',
        'response_content_type': 'responseContentType'
    }

    def __init__(self, url_pattern=None,response_content_type=None):
        self._url_pattern = None
        self._response_content_type = None

        if url_pattern is not None:
            self.url_pattern = url_pattern
        if response_content_type is not None:
            self.response_content_type = response_content_type

    @property
    def url_pattern(self):
        return self._url_pattern
    
    @url_pattern.setter
    def url_pattern(self, url_pattern):
        self._url_pattern = url_pattern

    @property
    def response_content_type(self):
        return self._response_content_type
    
    @response_content_type.setter
    def response_content_type(self, response_content_type):
        self._response_content_type = response_content_type


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ApiFilterType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
