"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .v_cloud_extensible_type import VCloudExtensibleType


class ErrorType(VCloudExtensibleType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'tenant_error': 'TenantErrorType',
        'stack_trace': 'str',
        'message': 'str',
        'major_error_code': 'int',
        'minor_error_code': 'str',
        'vendor_specific_error_code': 'str'
    }

    attribute_map = {
        'tenant_error': 'tenantError',
        'stack_trace': 'stackTrace',
        'message': 'message',
        'major_error_code': 'majorErrorCode',
        'minor_error_code': 'minorErrorCode',
        'vendor_specific_error_code': 'vendorSpecificErrorCode'
    }

    def __init__(self, tenant_error=None,stack_trace=None,message=None,major_error_code=None,minor_error_code=None,vendor_specific_error_code=None):
        self._tenant_error = None
        self._stack_trace = None
        self._message = None
        self._major_error_code = None
        self._minor_error_code = None
        self._vendor_specific_error_code = None

        if tenant_error is not None:
            self.tenant_error = tenant_error
        if stack_trace is not None:
            self.stack_trace = stack_trace
        if message is not None:
            self.message = message
        if major_error_code is not None:
            self.major_error_code = major_error_code
        if minor_error_code is not None:
            self.minor_error_code = minor_error_code
        if vendor_specific_error_code is not None:
            self.vendor_specific_error_code = vendor_specific_error_code

    @property
    def tenant_error(self):
        return self._tenant_error
    
    @tenant_error.setter
    def tenant_error(self, tenant_error):
        self._tenant_error = tenant_error

    @property
    def stack_trace(self):
        return self._stack_trace
    
    @stack_trace.setter
    def stack_trace(self, stack_trace):
        self._stack_trace = stack_trace

    @property
    def message(self):
        return self._message
    
    @message.setter
    def message(self, message):
        self._message = message

    @property
    def major_error_code(self):
        return self._major_error_code
    
    @major_error_code.setter
    def major_error_code(self, major_error_code):
        self._major_error_code = major_error_code

    @property
    def minor_error_code(self):
        return self._minor_error_code
    
    @minor_error_code.setter
    def minor_error_code(self, minor_error_code):
        self._minor_error_code = minor_error_code

    @property
    def vendor_specific_error_code(self):
        return self._vendor_specific_error_code
    
    @vendor_specific_error_code.setter
    def vendor_specific_error_code(self, vendor_specific_error_code):
        self._vendor_specific_error_code = vendor_specific_error_code


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ErrorType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
