"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .v_cloud_extensible_type import VCloudExtensibleType


class DhcpPoolServiceType(VCloudExtensibleType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'is_enabled': 'bool',
        'network': 'ReferenceType',
        'default_lease_time': 'int',
        'max_lease_time': 'int',
        'low_ip_address': 'str',
        'high_ip_address': 'str'
    }

    attribute_map = {
        'is_enabled': 'isEnabled',
        'network': 'network',
        'default_lease_time': 'defaultLeaseTime',
        'max_lease_time': 'maxLeaseTime',
        'low_ip_address': 'lowIpAddress',
        'high_ip_address': 'highIpAddress'
    }

    def __init__(self, is_enabled=None,network=None,default_lease_time=None,max_lease_time=None,low_ip_address=None,high_ip_address=None):
        self._is_enabled = None
        self._network = None
        self._default_lease_time = None
        self._max_lease_time = None
        self._low_ip_address = None
        self._high_ip_address = None

        if is_enabled is not None:
            self.is_enabled = is_enabled
        if network is not None:
            self.network = network
        if default_lease_time is not None:
            self.default_lease_time = default_lease_time
        if max_lease_time is not None:
            self.max_lease_time = max_lease_time
        if low_ip_address is not None:
            self.low_ip_address = low_ip_address
        if high_ip_address is not None:
            self.high_ip_address = high_ip_address

    @property
    def is_enabled(self):
        return self._is_enabled
    
    @is_enabled.setter
    def is_enabled(self, is_enabled):
        self._is_enabled = is_enabled

    @property
    def network(self):
        return self._network
    
    @network.setter
    def network(self, network):
        self._network = network

    @property
    def default_lease_time(self):
        return self._default_lease_time
    
    @default_lease_time.setter
    def default_lease_time(self, default_lease_time):
        self._default_lease_time = default_lease_time

    @property
    def max_lease_time(self):
        return self._max_lease_time
    
    @max_lease_time.setter
    def max_lease_time(self, max_lease_time):
        self._max_lease_time = max_lease_time

    @property
    def low_ip_address(self):
        return self._low_ip_address
    
    @low_ip_address.setter
    def low_ip_address(self, low_ip_address):
        self._low_ip_address = low_ip_address

    @property
    def high_ip_address(self):
        return self._high_ip_address
    
    @high_ip_address.setter
    def high_ip_address(self, high_ip_address):
        self._high_ip_address = high_ip_address


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, DhcpPoolServiceType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
