"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .v_cloud_extensible_type import VCloudExtensibleType


class CustomOrgLdapSettingsType(VCloudExtensibleType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'host_name': 'str',
        'port': 'int',
        'is_ssl': 'bool',
        'is_ssl_accept_all': 'bool',
        'custom_truststore': 'str',
        'realm': 'str',
        'search_base': 'str',
        'user_name': 'str',
        'password': 'str',
        'authentication_mechanism': 'str',
        'group_search_base': 'str',
        'is_group_search_base_enabled': 'bool',
        'connector_type': 'str',
        'user_attributes': 'OrgLdapUserAttributesType',
        'group_attributes': 'OrgLdapGroupAttributesType',
        'use_external_kerberos': 'bool'
    }

    attribute_map = {
        'host_name': 'hostName',
        'port': 'port',
        'is_ssl': 'isSsl',
        'is_ssl_accept_all': 'isSslAcceptAll',
        'custom_truststore': 'customTruststore',
        'realm': 'realm',
        'search_base': 'searchBase',
        'user_name': 'userName',
        'password': 'password',
        'authentication_mechanism': 'authenticationMechanism',
        'group_search_base': 'groupSearchBase',
        'is_group_search_base_enabled': 'isGroupSearchBaseEnabled',
        'connector_type': 'connectorType',
        'user_attributes': 'userAttributes',
        'group_attributes': 'groupAttributes',
        'use_external_kerberos': 'useExternalKerberos'
    }

    def __init__(self, host_name=None,port=None,is_ssl=None,is_ssl_accept_all=None,custom_truststore=None,realm=None,search_base=None,user_name=None,password=None,authentication_mechanism=None,group_search_base=None,is_group_search_base_enabled=None,connector_type=None,user_attributes=None,group_attributes=None,use_external_kerberos=None):
        self._host_name = None
        self._port = None
        self._is_ssl = None
        self._is_ssl_accept_all = None
        self._custom_truststore = None
        self._realm = None
        self._search_base = None
        self._user_name = None
        self._password = None
        self._authentication_mechanism = None
        self._group_search_base = None
        self._is_group_search_base_enabled = None
        self._connector_type = None
        self._user_attributes = None
        self._group_attributes = None
        self._use_external_kerberos = None

        if host_name is not None:
            self.host_name = host_name
        if port is not None:
            self.port = port
        if is_ssl is not None:
            self.is_ssl = is_ssl
        if is_ssl_accept_all is not None:
            self.is_ssl_accept_all = is_ssl_accept_all
        if custom_truststore is not None:
            self.custom_truststore = custom_truststore
        if realm is not None:
            self.realm = realm
        if search_base is not None:
            self.search_base = search_base
        if user_name is not None:
            self.user_name = user_name
        if password is not None:
            self.password = password
        if authentication_mechanism is not None:
            self.authentication_mechanism = authentication_mechanism
        if group_search_base is not None:
            self.group_search_base = group_search_base
        if is_group_search_base_enabled is not None:
            self.is_group_search_base_enabled = is_group_search_base_enabled
        if connector_type is not None:
            self.connector_type = connector_type
        if user_attributes is not None:
            self.user_attributes = user_attributes
        if group_attributes is not None:
            self.group_attributes = group_attributes
        if use_external_kerberos is not None:
            self.use_external_kerberos = use_external_kerberos

    @property
    def host_name(self):
        return self._host_name
    
    @host_name.setter
    def host_name(self, host_name):
        self._host_name = host_name

    @property
    def port(self):
        return self._port
    
    @port.setter
    def port(self, port):
        self._port = port

    @property
    def is_ssl(self):
        return self._is_ssl
    
    @is_ssl.setter
    def is_ssl(self, is_ssl):
        self._is_ssl = is_ssl

    @property
    def is_ssl_accept_all(self):
        return self._is_ssl_accept_all
    
    @is_ssl_accept_all.setter
    def is_ssl_accept_all(self, is_ssl_accept_all):
        self._is_ssl_accept_all = is_ssl_accept_all

    @property
    def custom_truststore(self):
        return self._custom_truststore
    
    @custom_truststore.setter
    def custom_truststore(self, custom_truststore):
        self._custom_truststore = custom_truststore

    @property
    def realm(self):
        return self._realm
    
    @realm.setter
    def realm(self, realm):
        self._realm = realm

    @property
    def search_base(self):
        return self._search_base
    
    @search_base.setter
    def search_base(self, search_base):
        self._search_base = search_base

    @property
    def user_name(self):
        return self._user_name
    
    @user_name.setter
    def user_name(self, user_name):
        self._user_name = user_name

    @property
    def password(self):
        return self._password
    
    @password.setter
    def password(self, password):
        self._password = password

    @property
    def authentication_mechanism(self):
        return self._authentication_mechanism
    
    @authentication_mechanism.setter
    def authentication_mechanism(self, authentication_mechanism):
        self._authentication_mechanism = authentication_mechanism

    @property
    def group_search_base(self):
        return self._group_search_base
    
    @group_search_base.setter
    def group_search_base(self, group_search_base):
        self._group_search_base = group_search_base

    @property
    def is_group_search_base_enabled(self):
        return self._is_group_search_base_enabled
    
    @is_group_search_base_enabled.setter
    def is_group_search_base_enabled(self, is_group_search_base_enabled):
        self._is_group_search_base_enabled = is_group_search_base_enabled

    @property
    def connector_type(self):
        return self._connector_type
    
    @connector_type.setter
    def connector_type(self, connector_type):
        self._connector_type = connector_type

    @property
    def user_attributes(self):
        return self._user_attributes
    
    @user_attributes.setter
    def user_attributes(self, user_attributes):
        self._user_attributes = user_attributes

    @property
    def group_attributes(self):
        return self._group_attributes
    
    @group_attributes.setter
    def group_attributes(self, group_attributes):
        self._group_attributes = group_attributes

    @property
    def use_external_kerberos(self):
        return self._use_external_kerberos
    
    @use_external_kerberos.setter
    def use_external_kerberos(self, use_external_kerberos):
        self._use_external_kerberos = use_external_kerberos


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CustomOrgLdapSettingsType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
