"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re


class SupportedVersionsType(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'version_info': 'list[VersionInfoType]',
        'schema_root': 'str',
        'alpha_version': 'VersionInfoType',
        'any': 'list[object]',
        'other_attributes': 'object'
    }

    attribute_map = {
        'version_info': 'versionInfo',
        'schema_root': 'schemaRoot',
        'alpha_version': 'alphaVersion',
        'any': 'any',
        'other_attributes': 'otherAttributes'
    }

    def __init__(self, version_info=None,schema_root=None,alpha_version=None,any=None,other_attributes=None):
        self._version_info = None
        self._schema_root = None
        self._alpha_version = None
        self._any = None
        self._other_attributes = None

        if version_info is not None:
            self.version_info = version_info
        if schema_root is not None:
            self.schema_root = schema_root
        if alpha_version is not None:
            self.alpha_version = alpha_version
        if any is not None:
            self.any = any
        if other_attributes is not None:
            self.other_attributes = other_attributes

    @property
    def version_info(self):
        return self._version_info
    
    @version_info.setter
    def version_info(self, version_info):
        self._version_info = version_info

    @property
    def schema_root(self):
        return self._schema_root
    
    @schema_root.setter
    def schema_root(self, schema_root):
        self._schema_root = schema_root

    @property
    def alpha_version(self):
        return self._alpha_version
    
    @alpha_version.setter
    def alpha_version(self, alpha_version):
        self._alpha_version = alpha_version

    @property
    def any(self):
        return self._any
    
    @any.setter
    def any(self, any):
        self._any = any

    @property
    def other_attributes(self):
        return self._other_attributes
    
    @other_attributes.setter
    def other_attributes(self, other_attributes):
        self._other_attributes = other_attributes


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SupportedVersionsType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
