"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .section_type import SectionType


class ProductSectionType(SectionType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'product': 'MsgType',
        'vendor': 'MsgType',
        'version': 'CimString',
        'full_version': 'CimString',
        'product_url': 'CimString',
        'vendor_url': 'CimString',
        'app_url': 'CimString',
        'icon': 'list[ProductSectionIcon]',
        'category_or_property': 'list[object]',
        'any': 'list[object]',
        'clazz': 'str',
        'instance': 'str'
    }

    attribute_map = {
        'product': 'product',
        'vendor': 'vendor',
        'version': 'version',
        'full_version': 'fullVersion',
        'product_url': 'productUrl',
        'vendor_url': 'vendorUrl',
        'app_url': 'appUrl',
        'icon': 'icon',
        'category_or_property': 'categoryOrProperty',
        'any': 'any',
        'clazz': 'clazz',
        'instance': 'instance'
    }

    def __init__(self, product=None,vendor=None,version=None,full_version=None,product_url=None,vendor_url=None,app_url=None,icon=None,category_or_property=None,any=None,clazz=None,instance=None):
        self._product = None
        self._vendor = None
        self._version = None
        self._full_version = None
        self._product_url = None
        self._vendor_url = None
        self._app_url = None
        self._icon = None
        self._category_or_property = None
        self._any = None
        self._clazz = None
        self._instance = None

        if product is not None:
            self.product = product
        if vendor is not None:
            self.vendor = vendor
        if version is not None:
            self.version = version
        if full_version is not None:
            self.full_version = full_version
        if product_url is not None:
            self.product_url = product_url
        if vendor_url is not None:
            self.vendor_url = vendor_url
        if app_url is not None:
            self.app_url = app_url
        if icon is not None:
            self.icon = icon
        if category_or_property is not None:
            self.category_or_property = category_or_property
        if any is not None:
            self.any = any
        if clazz is not None:
            self.clazz = clazz
        if instance is not None:
            self.instance = instance

    @property
    def product(self):
        return self._product
    
    @product.setter
    def product(self, product):
        self._product = product

    @property
    def vendor(self):
        return self._vendor
    
    @vendor.setter
    def vendor(self, vendor):
        self._vendor = vendor

    @property
    def version(self):
        return self._version
    
    @version.setter
    def version(self, version):
        self._version = version

    @property
    def full_version(self):
        return self._full_version
    
    @full_version.setter
    def full_version(self, full_version):
        self._full_version = full_version

    @property
    def product_url(self):
        return self._product_url
    
    @product_url.setter
    def product_url(self, product_url):
        self._product_url = product_url

    @property
    def vendor_url(self):
        return self._vendor_url
    
    @vendor_url.setter
    def vendor_url(self, vendor_url):
        self._vendor_url = vendor_url

    @property
    def app_url(self):
        return self._app_url
    
    @app_url.setter
    def app_url(self, app_url):
        self._app_url = app_url

    @property
    def icon(self):
        return self._icon
    
    @icon.setter
    def icon(self, icon):
        self._icon = icon

    @property
    def category_or_property(self):
        return self._category_or_property
    
    @category_or_property.setter
    def category_or_property(self, category_or_property):
        self._category_or_property = category_or_property

    @property
    def any(self):
        return self._any
    
    @any.setter
    def any(self, any):
        self._any = any

    @property
    def clazz(self):
        return self._clazz
    
    @clazz.setter
    def clazz(self, clazz):
        self._clazz = clazz

    @property
    def instance(self):
        return self._instance
    
    @instance.setter
    def instance(self, instance):
        self._instance = instance


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ProductSectionType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
