"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re


class CIMResourceAllocationSettingDataType(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'address': 'CimString',
        'address_on_parent': 'CimString',
        'allocation_units': 'CimString',
        'automatic_allocation': 'CimBoolean',
        'automatic_deallocation': 'CimBoolean',
        'caption': 'ResourceAllocationCaption',
        'changeable_type': 'ResourceAllocationChangeableType',
        'configuration_name': 'CimString',
        'connection': 'list[CimString]',
        'consumer_visibility': 'ConsumerVisibility',
        'description': 'CimString',
        'element_name': 'CimString',
        'generation': 'CimUnsignedLong',
        'host_resource': 'list[CimString]',
        'instance_id': 'CimString',
        'limit': 'CimUnsignedLong',
        'mapping_behavior': 'MappingBehavior',
        'other_resource_type': 'CimString',
        'parent': 'CimString',
        'pool_id': 'CimString',
        'reservation': 'CimUnsignedLong',
        'resource_sub_type': 'CimString',
        'resource_type': 'ResourceType',
        'virtual_quantity': 'CimUnsignedLong',
        'virtual_quantity_units': 'CimString',
        'weight': 'CimUnsignedInt',
        'any': 'list[object]',
        'other_attributes': 'object'
    }

    attribute_map = {
        'address': 'address',
        'address_on_parent': 'addressOnParent',
        'allocation_units': 'allocationUnits',
        'automatic_allocation': 'automaticAllocation',
        'automatic_deallocation': 'automaticDeallocation',
        'caption': 'caption',
        'changeable_type': 'changeableType',
        'configuration_name': 'configurationName',
        'connection': 'connection',
        'consumer_visibility': 'consumerVisibility',
        'description': 'description',
        'element_name': 'elementName',
        'generation': 'generation',
        'host_resource': 'hostResource',
        'instance_id': 'instanceID',
        'limit': 'limit',
        'mapping_behavior': 'mappingBehavior',
        'other_resource_type': 'otherResourceType',
        'parent': 'parent',
        'pool_id': 'poolID',
        'reservation': 'reservation',
        'resource_sub_type': 'resourceSubType',
        'resource_type': 'resourceType',
        'virtual_quantity': 'virtualQuantity',
        'virtual_quantity_units': 'virtualQuantityUnits',
        'weight': 'weight',
        'any': 'any',
        'other_attributes': 'otherAttributes'
    }

    def __init__(self, address=None,address_on_parent=None,allocation_units=None,automatic_allocation=None,automatic_deallocation=None,caption=None,changeable_type=None,configuration_name=None,connection=None,consumer_visibility=None,description=None,element_name=None,generation=None,host_resource=None,instance_id=None,limit=None,mapping_behavior=None,other_resource_type=None,parent=None,pool_id=None,reservation=None,resource_sub_type=None,resource_type=None,virtual_quantity=None,virtual_quantity_units=None,weight=None,any=None,other_attributes=None):
        self._address = None
        self._address_on_parent = None
        self._allocation_units = None
        self._automatic_allocation = None
        self._automatic_deallocation = None
        self._caption = None
        self._changeable_type = None
        self._configuration_name = None
        self._connection = None
        self._consumer_visibility = None
        self._description = None
        self._element_name = None
        self._generation = None
        self._host_resource = None
        self._instance_id = None
        self._limit = None
        self._mapping_behavior = None
        self._other_resource_type = None
        self._parent = None
        self._pool_id = None
        self._reservation = None
        self._resource_sub_type = None
        self._resource_type = None
        self._virtual_quantity = None
        self._virtual_quantity_units = None
        self._weight = None
        self._any = None
        self._other_attributes = None

        if address is not None:
            self.address = address
        if address_on_parent is not None:
            self.address_on_parent = address_on_parent
        if allocation_units is not None:
            self.allocation_units = allocation_units
        if automatic_allocation is not None:
            self.automatic_allocation = automatic_allocation
        if automatic_deallocation is not None:
            self.automatic_deallocation = automatic_deallocation
        if caption is not None:
            self.caption = caption
        if changeable_type is not None:
            self.changeable_type = changeable_type
        if configuration_name is not None:
            self.configuration_name = configuration_name
        if connection is not None:
            self.connection = connection
        if consumer_visibility is not None:
            self.consumer_visibility = consumer_visibility
        if description is not None:
            self.description = description
        if element_name is not None:
            self.element_name = element_name
        if generation is not None:
            self.generation = generation
        if host_resource is not None:
            self.host_resource = host_resource
        if instance_id is not None:
            self.instance_id = instance_id
        if limit is not None:
            self.limit = limit
        if mapping_behavior is not None:
            self.mapping_behavior = mapping_behavior
        if other_resource_type is not None:
            self.other_resource_type = other_resource_type
        if parent is not None:
            self.parent = parent
        if pool_id is not None:
            self.pool_id = pool_id
        if reservation is not None:
            self.reservation = reservation
        if resource_sub_type is not None:
            self.resource_sub_type = resource_sub_type
        if resource_type is not None:
            self.resource_type = resource_type
        if virtual_quantity is not None:
            self.virtual_quantity = virtual_quantity
        if virtual_quantity_units is not None:
            self.virtual_quantity_units = virtual_quantity_units
        if weight is not None:
            self.weight = weight
        if any is not None:
            self.any = any
        if other_attributes is not None:
            self.other_attributes = other_attributes

    @property
    def address(self):
        return self._address
    
    @address.setter
    def address(self, address):
        self._address = address

    @property
    def address_on_parent(self):
        return self._address_on_parent
    
    @address_on_parent.setter
    def address_on_parent(self, address_on_parent):
        self._address_on_parent = address_on_parent

    @property
    def allocation_units(self):
        return self._allocation_units
    
    @allocation_units.setter
    def allocation_units(self, allocation_units):
        self._allocation_units = allocation_units

    @property
    def automatic_allocation(self):
        return self._automatic_allocation
    
    @automatic_allocation.setter
    def automatic_allocation(self, automatic_allocation):
        self._automatic_allocation = automatic_allocation

    @property
    def automatic_deallocation(self):
        return self._automatic_deallocation
    
    @automatic_deallocation.setter
    def automatic_deallocation(self, automatic_deallocation):
        self._automatic_deallocation = automatic_deallocation

    @property
    def caption(self):
        return self._caption
    
    @caption.setter
    def caption(self, caption):
        self._caption = caption

    @property
    def changeable_type(self):
        return self._changeable_type
    
    @changeable_type.setter
    def changeable_type(self, changeable_type):
        self._changeable_type = changeable_type

    @property
    def configuration_name(self):
        return self._configuration_name
    
    @configuration_name.setter
    def configuration_name(self, configuration_name):
        self._configuration_name = configuration_name

    @property
    def connection(self):
        return self._connection
    
    @connection.setter
    def connection(self, connection):
        self._connection = connection

    @property
    def consumer_visibility(self):
        return self._consumer_visibility
    
    @consumer_visibility.setter
    def consumer_visibility(self, consumer_visibility):
        self._consumer_visibility = consumer_visibility

    @property
    def description(self):
        return self._description
    
    @description.setter
    def description(self, description):
        self._description = description

    @property
    def element_name(self):
        return self._element_name
    
    @element_name.setter
    def element_name(self, element_name):
        self._element_name = element_name

    @property
    def generation(self):
        return self._generation
    
    @generation.setter
    def generation(self, generation):
        self._generation = generation

    @property
    def host_resource(self):
        return self._host_resource
    
    @host_resource.setter
    def host_resource(self, host_resource):
        self._host_resource = host_resource

    @property
    def instance_id(self):
        return self._instance_id
    
    @instance_id.setter
    def instance_id(self, instance_id):
        self._instance_id = instance_id

    @property
    def limit(self):
        return self._limit
    
    @limit.setter
    def limit(self, limit):
        self._limit = limit

    @property
    def mapping_behavior(self):
        return self._mapping_behavior
    
    @mapping_behavior.setter
    def mapping_behavior(self, mapping_behavior):
        self._mapping_behavior = mapping_behavior

    @property
    def other_resource_type(self):
        return self._other_resource_type
    
    @other_resource_type.setter
    def other_resource_type(self, other_resource_type):
        self._other_resource_type = other_resource_type

    @property
    def parent(self):
        return self._parent
    
    @parent.setter
    def parent(self, parent):
        self._parent = parent

    @property
    def pool_id(self):
        return self._pool_id
    
    @pool_id.setter
    def pool_id(self, pool_id):
        self._pool_id = pool_id

    @property
    def reservation(self):
        return self._reservation
    
    @reservation.setter
    def reservation(self, reservation):
        self._reservation = reservation

    @property
    def resource_sub_type(self):
        return self._resource_sub_type
    
    @resource_sub_type.setter
    def resource_sub_type(self, resource_sub_type):
        self._resource_sub_type = resource_sub_type

    @property
    def resource_type(self):
        return self._resource_type
    
    @resource_type.setter
    def resource_type(self, resource_type):
        self._resource_type = resource_type

    @property
    def virtual_quantity(self):
        return self._virtual_quantity
    
    @virtual_quantity.setter
    def virtual_quantity(self, virtual_quantity):
        self._virtual_quantity = virtual_quantity

    @property
    def virtual_quantity_units(self):
        return self._virtual_quantity_units
    
    @virtual_quantity_units.setter
    def virtual_quantity_units(self, virtual_quantity_units):
        self._virtual_quantity_units = virtual_quantity_units

    @property
    def weight(self):
        return self._weight
    
    @weight.setter
    def weight(self, weight):
        self._weight = weight

    @property
    def any(self):
        return self._any
    
    @any.setter
    def any(self, any):
        self._any = any

    @property
    def other_attributes(self):
        return self._other_attributes
    
    @other_attributes.setter
    def other_attributes(self, other_attributes):
        self._other_attributes = other_attributes


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CIMResourceAllocationSettingDataType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
