# Generated by Django 2.2.13 on 2020-10-25 18:35

from django.db import migrations, models
from django_eveonline_doctrine_manager.utilities.fittings import parse_eft_format, get_required_skills, get_market_format, get_ship_name
import json 

"""
This migration takes a long time. Sorry! It's worth it in the end. 
"""

def refresh_fittings(apps, schema_editor):
    print("This migration is going to take a while... Sorry!")
    EveFitting = apps.get_model(
        'django_eveonline_doctrine_manager', 'EveFitting')
    for fitting in EveFitting.objects.all():
        fitting.parsed_format_raw = json.dumps(parse_eft_format(fitting))
        fitting.required_skills_raw = json.dumps(get_required_skills(fitting))
        fitting.market_format_raw = get_market_format(fitting)
        fitting.ship_name = get_ship_name(fitting)
        fitting.save()

class Migration(migrations.Migration):

    dependencies = [
        ('django_eveonline_doctrine_manager',
         '0013_auto_20201025_1906'),
    ]

    operations = [
        migrations.RunPython(
            refresh_fittings, reverse_code=migrations.RunPython.noop),
    ]
