# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import V2ConversationMessageTypingEventForWorkflowTopicConversationNotificationTemplateBody
    from . import V2ConversationMessageTypingEventForWorkflowTopicConversationNotificationTemplateFooter
    from . import V2ConversationMessageTypingEventForWorkflowTopicConversationNotificationTemplateHeader

class V2ConversationMessageTypingEventForWorkflowTopicConversationContentNotificationTemplate(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        V2ConversationMessageTypingEventForWorkflowTopicConversationContentNotificationTemplate - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'language': 'str',
            'header': 'V2ConversationMessageTypingEventForWorkflowTopicConversationNotificationTemplateHeader',
            'body': 'V2ConversationMessageTypingEventForWorkflowTopicConversationNotificationTemplateBody',
            'footer': 'V2ConversationMessageTypingEventForWorkflowTopicConversationNotificationTemplateFooter'
        }

        self.attribute_map = {
            'id': 'id',
            'language': 'language',
            'header': 'header',
            'body': 'body',
            'footer': 'footer'
        }

        self._id = None
        self._language = None
        self._header = None
        self._body = None
        self._footer = None

    @property
    def id(self) -> str:
        """
        Gets the id of this V2ConversationMessageTypingEventForWorkflowTopicConversationContentNotificationTemplate.


        :return: The id of this V2ConversationMessageTypingEventForWorkflowTopicConversationContentNotificationTemplate.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this V2ConversationMessageTypingEventForWorkflowTopicConversationContentNotificationTemplate.


        :param id: The id of this V2ConversationMessageTypingEventForWorkflowTopicConversationContentNotificationTemplate.
        :type: str
        """
        

        self._id = id

    @property
    def language(self) -> str:
        """
        Gets the language of this V2ConversationMessageTypingEventForWorkflowTopicConversationContentNotificationTemplate.


        :return: The language of this V2ConversationMessageTypingEventForWorkflowTopicConversationContentNotificationTemplate.
        :rtype: str
        """
        return self._language

    @language.setter
    def language(self, language: str) -> None:
        """
        Sets the language of this V2ConversationMessageTypingEventForWorkflowTopicConversationContentNotificationTemplate.


        :param language: The language of this V2ConversationMessageTypingEventForWorkflowTopicConversationContentNotificationTemplate.
        :type: str
        """
        

        self._language = language

    @property
    def header(self) -> 'V2ConversationMessageTypingEventForWorkflowTopicConversationNotificationTemplateHeader':
        """
        Gets the header of this V2ConversationMessageTypingEventForWorkflowTopicConversationContentNotificationTemplate.


        :return: The header of this V2ConversationMessageTypingEventForWorkflowTopicConversationContentNotificationTemplate.
        :rtype: V2ConversationMessageTypingEventForWorkflowTopicConversationNotificationTemplateHeader
        """
        return self._header

    @header.setter
    def header(self, header: 'V2ConversationMessageTypingEventForWorkflowTopicConversationNotificationTemplateHeader') -> None:
        """
        Sets the header of this V2ConversationMessageTypingEventForWorkflowTopicConversationContentNotificationTemplate.


        :param header: The header of this V2ConversationMessageTypingEventForWorkflowTopicConversationContentNotificationTemplate.
        :type: V2ConversationMessageTypingEventForWorkflowTopicConversationNotificationTemplateHeader
        """
        

        self._header = header

    @property
    def body(self) -> 'V2ConversationMessageTypingEventForWorkflowTopicConversationNotificationTemplateBody':
        """
        Gets the body of this V2ConversationMessageTypingEventForWorkflowTopicConversationContentNotificationTemplate.


        :return: The body of this V2ConversationMessageTypingEventForWorkflowTopicConversationContentNotificationTemplate.
        :rtype: V2ConversationMessageTypingEventForWorkflowTopicConversationNotificationTemplateBody
        """
        return self._body

    @body.setter
    def body(self, body: 'V2ConversationMessageTypingEventForWorkflowTopicConversationNotificationTemplateBody') -> None:
        """
        Sets the body of this V2ConversationMessageTypingEventForWorkflowTopicConversationContentNotificationTemplate.


        :param body: The body of this V2ConversationMessageTypingEventForWorkflowTopicConversationContentNotificationTemplate.
        :type: V2ConversationMessageTypingEventForWorkflowTopicConversationNotificationTemplateBody
        """
        

        self._body = body

    @property
    def footer(self) -> 'V2ConversationMessageTypingEventForWorkflowTopicConversationNotificationTemplateFooter':
        """
        Gets the footer of this V2ConversationMessageTypingEventForWorkflowTopicConversationContentNotificationTemplate.


        :return: The footer of this V2ConversationMessageTypingEventForWorkflowTopicConversationContentNotificationTemplate.
        :rtype: V2ConversationMessageTypingEventForWorkflowTopicConversationNotificationTemplateFooter
        """
        return self._footer

    @footer.setter
    def footer(self, footer: 'V2ConversationMessageTypingEventForWorkflowTopicConversationNotificationTemplateFooter') -> None:
        """
        Sets the footer of this V2ConversationMessageTypingEventForWorkflowTopicConversationContentNotificationTemplate.


        :param footer: The footer of this V2ConversationMessageTypingEventForWorkflowTopicConversationContentNotificationTemplate.
        :type: V2ConversationMessageTypingEventForWorkflowTopicConversationNotificationTemplateFooter
        """
        

        self._footer = footer

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

