# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import V2ConversationMessageTypingEventForUserTopicConversationButtonComponent
    from . import V2ConversationMessageTypingEventForUserTopicConversationContentActions

class V2ConversationMessageTypingEventForUserTopicConversationContentGeneric(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        V2ConversationMessageTypingEventForUserTopicConversationContentGeneric - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'title': 'str',
            'description': 'str',
            'image': 'str',
            'video': 'str',
            'actions': 'V2ConversationMessageTypingEventForUserTopicConversationContentActions',
            'components': 'list[V2ConversationMessageTypingEventForUserTopicConversationButtonComponent]'
        }

        self.attribute_map = {
            'title': 'title',
            'description': 'description',
            'image': 'image',
            'video': 'video',
            'actions': 'actions',
            'components': 'components'
        }

        self._title = None
        self._description = None
        self._image = None
        self._video = None
        self._actions = None
        self._components = None

    @property
    def title(self) -> str:
        """
        Gets the title of this V2ConversationMessageTypingEventForUserTopicConversationContentGeneric.


        :return: The title of this V2ConversationMessageTypingEventForUserTopicConversationContentGeneric.
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title: str) -> None:
        """
        Sets the title of this V2ConversationMessageTypingEventForUserTopicConversationContentGeneric.


        :param title: The title of this V2ConversationMessageTypingEventForUserTopicConversationContentGeneric.
        :type: str
        """
        

        self._title = title

    @property
    def description(self) -> str:
        """
        Gets the description of this V2ConversationMessageTypingEventForUserTopicConversationContentGeneric.


        :return: The description of this V2ConversationMessageTypingEventForUserTopicConversationContentGeneric.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description: str) -> None:
        """
        Sets the description of this V2ConversationMessageTypingEventForUserTopicConversationContentGeneric.


        :param description: The description of this V2ConversationMessageTypingEventForUserTopicConversationContentGeneric.
        :type: str
        """
        

        self._description = description

    @property
    def image(self) -> str:
        """
        Gets the image of this V2ConversationMessageTypingEventForUserTopicConversationContentGeneric.


        :return: The image of this V2ConversationMessageTypingEventForUserTopicConversationContentGeneric.
        :rtype: str
        """
        return self._image

    @image.setter
    def image(self, image: str) -> None:
        """
        Sets the image of this V2ConversationMessageTypingEventForUserTopicConversationContentGeneric.


        :param image: The image of this V2ConversationMessageTypingEventForUserTopicConversationContentGeneric.
        :type: str
        """
        

        self._image = image

    @property
    def video(self) -> str:
        """
        Gets the video of this V2ConversationMessageTypingEventForUserTopicConversationContentGeneric.


        :return: The video of this V2ConversationMessageTypingEventForUserTopicConversationContentGeneric.
        :rtype: str
        """
        return self._video

    @video.setter
    def video(self, video: str) -> None:
        """
        Sets the video of this V2ConversationMessageTypingEventForUserTopicConversationContentGeneric.


        :param video: The video of this V2ConversationMessageTypingEventForUserTopicConversationContentGeneric.
        :type: str
        """
        

        self._video = video

    @property
    def actions(self) -> 'V2ConversationMessageTypingEventForUserTopicConversationContentActions':
        """
        Gets the actions of this V2ConversationMessageTypingEventForUserTopicConversationContentGeneric.


        :return: The actions of this V2ConversationMessageTypingEventForUserTopicConversationContentGeneric.
        :rtype: V2ConversationMessageTypingEventForUserTopicConversationContentActions
        """
        return self._actions

    @actions.setter
    def actions(self, actions: 'V2ConversationMessageTypingEventForUserTopicConversationContentActions') -> None:
        """
        Sets the actions of this V2ConversationMessageTypingEventForUserTopicConversationContentGeneric.


        :param actions: The actions of this V2ConversationMessageTypingEventForUserTopicConversationContentGeneric.
        :type: V2ConversationMessageTypingEventForUserTopicConversationContentActions
        """
        

        self._actions = actions

    @property
    def components(self) -> List['V2ConversationMessageTypingEventForUserTopicConversationButtonComponent']:
        """
        Gets the components of this V2ConversationMessageTypingEventForUserTopicConversationContentGeneric.


        :return: The components of this V2ConversationMessageTypingEventForUserTopicConversationContentGeneric.
        :rtype: list[V2ConversationMessageTypingEventForUserTopicConversationButtonComponent]
        """
        return self._components

    @components.setter
    def components(self, components: List['V2ConversationMessageTypingEventForUserTopicConversationButtonComponent']) -> None:
        """
        Sets the components of this V2ConversationMessageTypingEventForUserTopicConversationContentGeneric.


        :param components: The components of this V2ConversationMessageTypingEventForUserTopicConversationContentGeneric.
        :type: list[V2ConversationMessageTypingEventForUserTopicConversationButtonComponent]
        """
        

        self._components = components

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

