# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import RoleDivisionGrants

class TrustMemberCreate(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        TrustMemberCreate - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'role_ids': 'list[str]',
            'role_divisions': 'RoleDivisionGrants'
        }

        self.attribute_map = {
            'id': 'id',
            'role_ids': 'roleIds',
            'role_divisions': 'roleDivisions'
        }

        self._id = None
        self._role_ids = None
        self._role_divisions = None

    @property
    def id(self) -> str:
        """
        Gets the id of this TrustMemberCreate.
        Trustee User or Group Id

        :return: The id of this TrustMemberCreate.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this TrustMemberCreate.
        Trustee User or Group Id

        :param id: The id of this TrustMemberCreate.
        :type: str
        """
        

        self._id = id

    @property
    def role_ids(self) -> List[str]:
        """
        Gets the role_ids of this TrustMemberCreate.
        The list of roles to be granted to this user or group. Roles will be granted in all divisions.

        :return: The role_ids of this TrustMemberCreate.
        :rtype: list[str]
        """
        return self._role_ids

    @role_ids.setter
    def role_ids(self, role_ids: List[str]) -> None:
        """
        Sets the role_ids of this TrustMemberCreate.
        The list of roles to be granted to this user or group. Roles will be granted in all divisions.

        :param role_ids: The role_ids of this TrustMemberCreate.
        :type: list[str]
        """
        

        self._role_ids = role_ids

    @property
    def role_divisions(self) -> 'RoleDivisionGrants':
        """
        Gets the role_divisions of this TrustMemberCreate.
        The list of trustor organization roles granting this user or group access paired with the divisions for those roles.

        :return: The role_divisions of this TrustMemberCreate.
        :rtype: RoleDivisionGrants
        """
        return self._role_divisions

    @role_divisions.setter
    def role_divisions(self, role_divisions: 'RoleDivisionGrants') -> None:
        """
        Sets the role_divisions of this TrustMemberCreate.
        The list of trustor organization roles granting this user or group access paired with the divisions for those roles.

        :param role_divisions: The role_divisions of this TrustMemberCreate.
        :type: RoleDivisionGrants
        """
        

        self._role_divisions = role_divisions

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

