# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class TranscriptionSettings(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        TranscriptionSettings - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'transcription': 'str',
            'transcription_confidence_threshold': 'int',
            'low_latency_transcription_enabled': 'bool',
            'content_search_enabled': 'bool'
        }

        self.attribute_map = {
            'transcription': 'transcription',
            'transcription_confidence_threshold': 'transcriptionConfidenceThreshold',
            'low_latency_transcription_enabled': 'lowLatencyTranscriptionEnabled',
            'content_search_enabled': 'contentSearchEnabled'
        }

        self._transcription = None
        self._transcription_confidence_threshold = None
        self._low_latency_transcription_enabled = None
        self._content_search_enabled = None

    @property
    def transcription(self) -> str:
        """
        Gets the transcription of this TranscriptionSettings.
        Setting to enable/disable transcription capability

        :return: The transcription of this TranscriptionSettings.
        :rtype: str
        """
        return self._transcription

    @transcription.setter
    def transcription(self, transcription: str) -> None:
        """
        Sets the transcription of this TranscriptionSettings.
        Setting to enable/disable transcription capability

        :param transcription: The transcription of this TranscriptionSettings.
        :type: str
        """
        if isinstance(transcription, int):
            transcription = str(transcription)
        allowed_values = ["Disabled", "EnabledGlobally", "EnabledQueueFlow"]
        if transcription.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for transcription -> " + transcription)
            self._transcription = "outdated_sdk_version"
        else:
            self._transcription = transcription

    @property
    def transcription_confidence_threshold(self) -> int:
        """
        Gets the transcription_confidence_threshold of this TranscriptionSettings.
        Configure confidence threshold. The possible values are from 1 to 100.

        :return: The transcription_confidence_threshold of this TranscriptionSettings.
        :rtype: int
        """
        return self._transcription_confidence_threshold

    @transcription_confidence_threshold.setter
    def transcription_confidence_threshold(self, transcription_confidence_threshold: int) -> None:
        """
        Sets the transcription_confidence_threshold of this TranscriptionSettings.
        Configure confidence threshold. The possible values are from 1 to 100.

        :param transcription_confidence_threshold: The transcription_confidence_threshold of this TranscriptionSettings.
        :type: int
        """
        

        self._transcription_confidence_threshold = transcription_confidence_threshold

    @property
    def low_latency_transcription_enabled(self) -> bool:
        """
        Gets the low_latency_transcription_enabled of this TranscriptionSettings.
        Boolean flag indicating whether low latency transcription via Notification API is enabled

        :return: The low_latency_transcription_enabled of this TranscriptionSettings.
        :rtype: bool
        """
        return self._low_latency_transcription_enabled

    @low_latency_transcription_enabled.setter
    def low_latency_transcription_enabled(self, low_latency_transcription_enabled: bool) -> None:
        """
        Sets the low_latency_transcription_enabled of this TranscriptionSettings.
        Boolean flag indicating whether low latency transcription via Notification API is enabled

        :param low_latency_transcription_enabled: The low_latency_transcription_enabled of this TranscriptionSettings.
        :type: bool
        """
        

        self._low_latency_transcription_enabled = low_latency_transcription_enabled

    @property
    def content_search_enabled(self) -> bool:
        """
        Gets the content_search_enabled of this TranscriptionSettings.
        Setting to enable/disable content search

        :return: The content_search_enabled of this TranscriptionSettings.
        :rtype: bool
        """
        return self._content_search_enabled

    @content_search_enabled.setter
    def content_search_enabled(self, content_search_enabled: bool) -> None:
        """
        Sets the content_search_enabled of this TranscriptionSettings.
        Setting to enable/disable content search

        :param content_search_enabled: The content_search_enabled of this TranscriptionSettings.
        :type: bool
        """
        

        self._content_search_enabled = content_search_enabled

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

