# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class RequestConfig(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        RequestConfig - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'request_url_template': 'str',
            'request_template': 'str',
            'request_template_uri': 'str',
            'request_type': 'str',
            'headers': 'dict(str, str)'
        }

        self.attribute_map = {
            'request_url_template': 'requestUrlTemplate',
            'request_template': 'requestTemplate',
            'request_template_uri': 'requestTemplateUri',
            'request_type': 'requestType',
            'headers': 'headers'
        }

        self._request_url_template = None
        self._request_template = None
        self._request_template_uri = None
        self._request_type = None
        self._headers = None

    @property
    def request_url_template(self) -> str:
        """
        Gets the request_url_template of this RequestConfig.
        URL that may include placeholders for requests to 3rd party service

        :return: The request_url_template of this RequestConfig.
        :rtype: str
        """
        return self._request_url_template

    @request_url_template.setter
    def request_url_template(self, request_url_template: str) -> None:
        """
        Sets the request_url_template of this RequestConfig.
        URL that may include placeholders for requests to 3rd party service

        :param request_url_template: The request_url_template of this RequestConfig.
        :type: str
        """
        

        self._request_url_template = request_url_template

    @property
    def request_template(self) -> str:
        """
        Gets the request_template of this RequestConfig.
        Velocity template to define request body sent to 3rd party service.

        :return: The request_template of this RequestConfig.
        :rtype: str
        """
        return self._request_template

    @request_template.setter
    def request_template(self, request_template: str) -> None:
        """
        Sets the request_template of this RequestConfig.
        Velocity template to define request body sent to 3rd party service.

        :param request_template: The request_template of this RequestConfig.
        :type: str
        """
        

        self._request_template = request_template

    @property
    def request_template_uri(self) -> str:
        """
        Gets the request_template_uri of this RequestConfig.
        URI to retrieve requestTemplate

        :return: The request_template_uri of this RequestConfig.
        :rtype: str
        """
        return self._request_template_uri

    @request_template_uri.setter
    def request_template_uri(self, request_template_uri: str) -> None:
        """
        Sets the request_template_uri of this RequestConfig.
        URI to retrieve requestTemplate

        :param request_template_uri: The request_template_uri of this RequestConfig.
        :type: str
        """
        

        self._request_template_uri = request_template_uri

    @property
    def request_type(self) -> str:
        """
        Gets the request_type of this RequestConfig.
        HTTP method to use for request

        :return: The request_type of this RequestConfig.
        :rtype: str
        """
        return self._request_type

    @request_type.setter
    def request_type(self, request_type: str) -> None:
        """
        Sets the request_type of this RequestConfig.
        HTTP method to use for request

        :param request_type: The request_type of this RequestConfig.
        :type: str
        """
        

        self._request_type = request_type

    @property
    def headers(self) -> Dict[str, str]:
        """
        Gets the headers of this RequestConfig.
        Headers to include in request in (Header Name, Value) pairs.

        :return: The headers of this RequestConfig.
        :rtype: dict(str, str)
        """
        return self._headers

    @headers.setter
    def headers(self, headers: Dict[str, str]) -> None:
        """
        Sets the headers of this RequestConfig.
        Headers to include in request in (Header Name, Value) pairs.

        :param headers: The headers of this RequestConfig.
        :type: dict(str, str)
        """
        

        self._headers = headers

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

