# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class RecordingUploadReportRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        RecordingUploadReportRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'date_since': 'datetime',
            'upload_status': 'str'
        }

        self.attribute_map = {
            'date_since': 'dateSince',
            'upload_status': 'uploadStatus'
        }

        self._date_since = None
        self._upload_status = None

    @property
    def date_since(self) -> datetime:
        """
        Gets the date_since of this RecordingUploadReportRequest.
        Report will include uploads since this date. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_since of this RecordingUploadReportRequest.
        :rtype: datetime
        """
        return self._date_since

    @date_since.setter
    def date_since(self, date_since: datetime) -> None:
        """
        Sets the date_since of this RecordingUploadReportRequest.
        Report will include uploads since this date. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_since: The date_since of this RecordingUploadReportRequest.
        :type: datetime
        """
        

        self._date_since = date_since

    @property
    def upload_status(self) -> str:
        """
        Gets the upload_status of this RecordingUploadReportRequest.
        Report will include uploads with this status

        :return: The upload_status of this RecordingUploadReportRequest.
        :rtype: str
        """
        return self._upload_status

    @upload_status.setter
    def upload_status(self, upload_status: str) -> None:
        """
        Sets the upload_status of this RecordingUploadReportRequest.
        Report will include uploads with this status

        :param upload_status: The upload_status of this RecordingUploadReportRequest.
        :type: str
        """
        if isinstance(upload_status, int):
            upload_status = str(upload_status)
        allowed_values = ["Pending", "Success", "Failure", "WaitForConversation"]
        if upload_status.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for upload_status -> " + upload_status)
            self._upload_status = "outdated_sdk_version"
        else:
            self._upload_status = upload_status

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

