# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class RecordingRetention(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        RecordingRetention - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'conversation_id': 'str',
            'recording_id': 'str',
            'archive_date': 'datetime',
            'archive_medium': 'str',
            'delete_date': 'datetime',
            'export_date': 'datetime',
            'exported_date': 'datetime',
            'creation_time': 'datetime'
        }

        self.attribute_map = {
            'conversation_id': 'conversationId',
            'recording_id': 'recordingId',
            'archive_date': 'archiveDate',
            'archive_medium': 'archiveMedium',
            'delete_date': 'deleteDate',
            'export_date': 'exportDate',
            'exported_date': 'exportedDate',
            'creation_time': 'creationTime'
        }

        self._conversation_id = None
        self._recording_id = None
        self._archive_date = None
        self._archive_medium = None
        self._delete_date = None
        self._export_date = None
        self._exported_date = None
        self._creation_time = None

    @property
    def conversation_id(self) -> str:
        """
        Gets the conversation_id of this RecordingRetention.


        :return: The conversation_id of this RecordingRetention.
        :rtype: str
        """
        return self._conversation_id

    @conversation_id.setter
    def conversation_id(self, conversation_id: str) -> None:
        """
        Sets the conversation_id of this RecordingRetention.


        :param conversation_id: The conversation_id of this RecordingRetention.
        :type: str
        """
        

        self._conversation_id = conversation_id

    @property
    def recording_id(self) -> str:
        """
        Gets the recording_id of this RecordingRetention.


        :return: The recording_id of this RecordingRetention.
        :rtype: str
        """
        return self._recording_id

    @recording_id.setter
    def recording_id(self, recording_id: str) -> None:
        """
        Sets the recording_id of this RecordingRetention.


        :param recording_id: The recording_id of this RecordingRetention.
        :type: str
        """
        

        self._recording_id = recording_id

    @property
    def archive_date(self) -> datetime:
        """
        Gets the archive_date of this RecordingRetention.
        The date the recording will be archived. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The archive_date of this RecordingRetention.
        :rtype: datetime
        """
        return self._archive_date

    @archive_date.setter
    def archive_date(self, archive_date: datetime) -> None:
        """
        Sets the archive_date of this RecordingRetention.
        The date the recording will be archived. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param archive_date: The archive_date of this RecordingRetention.
        :type: datetime
        """
        

        self._archive_date = archive_date

    @property
    def archive_medium(self) -> str:
        """
        Gets the archive_medium of this RecordingRetention.
        The type of archive medium used. Example: CloudArchive

        :return: The archive_medium of this RecordingRetention.
        :rtype: str
        """
        return self._archive_medium

    @archive_medium.setter
    def archive_medium(self, archive_medium: str) -> None:
        """
        Sets the archive_medium of this RecordingRetention.
        The type of archive medium used. Example: CloudArchive

        :param archive_medium: The archive_medium of this RecordingRetention.
        :type: str
        """
        if isinstance(archive_medium, int):
            archive_medium = str(archive_medium)
        allowed_values = ["CLOUDARCHIVE"]
        if archive_medium.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for archive_medium -> " + archive_medium)
            self._archive_medium = "outdated_sdk_version"
        else:
            self._archive_medium = archive_medium

    @property
    def delete_date(self) -> datetime:
        """
        Gets the delete_date of this RecordingRetention.
        The date the recording will be deleted. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The delete_date of this RecordingRetention.
        :rtype: datetime
        """
        return self._delete_date

    @delete_date.setter
    def delete_date(self, delete_date: datetime) -> None:
        """
        Sets the delete_date of this RecordingRetention.
        The date the recording will be deleted. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param delete_date: The delete_date of this RecordingRetention.
        :type: datetime
        """
        

        self._delete_date = delete_date

    @property
    def export_date(self) -> datetime:
        """
        Gets the export_date of this RecordingRetention.
        The date the recording will be exported. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The export_date of this RecordingRetention.
        :rtype: datetime
        """
        return self._export_date

    @export_date.setter
    def export_date(self, export_date: datetime) -> None:
        """
        Sets the export_date of this RecordingRetention.
        The date the recording will be exported. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param export_date: The export_date of this RecordingRetention.
        :type: datetime
        """
        

        self._export_date = export_date

    @property
    def exported_date(self) -> datetime:
        """
        Gets the exported_date of this RecordingRetention.
        The date the recording was exported. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The exported_date of this RecordingRetention.
        :rtype: datetime
        """
        return self._exported_date

    @exported_date.setter
    def exported_date(self, exported_date: datetime) -> None:
        """
        Sets the exported_date of this RecordingRetention.
        The date the recording was exported. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param exported_date: The exported_date of this RecordingRetention.
        :type: datetime
        """
        

        self._exported_date = exported_date

    @property
    def creation_time(self) -> datetime:
        """
        Gets the creation_time of this RecordingRetention.
        The creation time of the recording. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The creation_time of this RecordingRetention.
        :rtype: datetime
        """
        return self._creation_time

    @creation_time.setter
    def creation_time(self, creation_time: datetime) -> None:
        """
        Sets the creation_time of this RecordingRetention.
        The creation time of the recording. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param creation_time: The creation_time of this RecordingRetention.
        :type: datetime
        """
        

        self._creation_time = creation_time

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

