# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import AddressableEntityRef
    from . import DomainEntityRef
    from . import MessageInfo
    from . import PropertyChange

class QualityAuditLogMessage(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        QualityAuditLogMessage - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'user_home_org_id': 'str',
            'user_trustee_org_id': 'str',
            'user': 'DomainEntityRef',
            'client': 'AddressableEntityRef',
            'remote_ips': 'list[str]',
            'service_name': 'str',
            'level': 'str',
            'status': 'str',
            'event_date': 'datetime',
            'message_info': 'MessageInfo',
            'action': 'str',
            'entity': 'DomainEntityRef',
            'entity_type': 'str',
            'property_changes': 'list[PropertyChange]',
            'context': 'dict(str, str)'
        }

        self.attribute_map = {
            'id': 'id',
            'user_home_org_id': 'userHomeOrgId',
            'user_trustee_org_id': 'userTrusteeOrgId',
            'user': 'user',
            'client': 'client',
            'remote_ips': 'remoteIps',
            'service_name': 'serviceName',
            'level': 'level',
            'status': 'status',
            'event_date': 'eventDate',
            'message_info': 'messageInfo',
            'action': 'action',
            'entity': 'entity',
            'entity_type': 'entityType',
            'property_changes': 'propertyChanges',
            'context': 'context'
        }

        self._id = None
        self._user_home_org_id = None
        self._user_trustee_org_id = None
        self._user = None
        self._client = None
        self._remote_ips = None
        self._service_name = None
        self._level = None
        self._status = None
        self._event_date = None
        self._message_info = None
        self._action = None
        self._entity = None
        self._entity_type = None
        self._property_changes = None
        self._context = None

    @property
    def id(self) -> str:
        """
        Gets the id of this QualityAuditLogMessage.
        Id of the audit message.

        :return: The id of this QualityAuditLogMessage.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this QualityAuditLogMessage.
        Id of the audit message.

        :param id: The id of this QualityAuditLogMessage.
        :type: str
        """
        

        self._id = id

    @property
    def user_home_org_id(self) -> str:
        """
        Gets the user_home_org_id of this QualityAuditLogMessage.
        Home Organization Id associated with this audit message.

        :return: The user_home_org_id of this QualityAuditLogMessage.
        :rtype: str
        """
        return self._user_home_org_id

    @user_home_org_id.setter
    def user_home_org_id(self, user_home_org_id: str) -> None:
        """
        Sets the user_home_org_id of this QualityAuditLogMessage.
        Home Organization Id associated with this audit message.

        :param user_home_org_id: The user_home_org_id of this QualityAuditLogMessage.
        :type: str
        """
        

        self._user_home_org_id = user_home_org_id

    @property
    def user_trustee_org_id(self) -> str:
        """
        Gets the user_trustee_org_id of this QualityAuditLogMessage.
        Trustee Organization Id if this audit message is from trustee access.

        :return: The user_trustee_org_id of this QualityAuditLogMessage.
        :rtype: str
        """
        return self._user_trustee_org_id

    @user_trustee_org_id.setter
    def user_trustee_org_id(self, user_trustee_org_id: str) -> None:
        """
        Sets the user_trustee_org_id of this QualityAuditLogMessage.
        Trustee Organization Id if this audit message is from trustee access.

        :param user_trustee_org_id: The user_trustee_org_id of this QualityAuditLogMessage.
        :type: str
        """
        

        self._user_trustee_org_id = user_trustee_org_id

    @property
    def user(self) -> 'DomainEntityRef':
        """
        Gets the user of this QualityAuditLogMessage.
        User associated with this audit message.

        :return: The user of this QualityAuditLogMessage.
        :rtype: DomainEntityRef
        """
        return self._user

    @user.setter
    def user(self, user: 'DomainEntityRef') -> None:
        """
        Sets the user of this QualityAuditLogMessage.
        User associated with this audit message.

        :param user: The user of this QualityAuditLogMessage.
        :type: DomainEntityRef
        """
        

        self._user = user

    @property
    def client(self) -> 'AddressableEntityRef':
        """
        Gets the client of this QualityAuditLogMessage.
        Client associated with this audit message.

        :return: The client of this QualityAuditLogMessage.
        :rtype: AddressableEntityRef
        """
        return self._client

    @client.setter
    def client(self, client: 'AddressableEntityRef') -> None:
        """
        Sets the client of this QualityAuditLogMessage.
        Client associated with this audit message.

        :param client: The client of this QualityAuditLogMessage.
        :type: AddressableEntityRef
        """
        

        self._client = client

    @property
    def remote_ips(self) -> List[str]:
        """
        Gets the remote_ips of this QualityAuditLogMessage.
        List of IP addresses of systems that originated or handled the request.

        :return: The remote_ips of this QualityAuditLogMessage.
        :rtype: list[str]
        """
        return self._remote_ips

    @remote_ips.setter
    def remote_ips(self, remote_ips: List[str]) -> None:
        """
        Sets the remote_ips of this QualityAuditLogMessage.
        List of IP addresses of systems that originated or handled the request.

        :param remote_ips: The remote_ips of this QualityAuditLogMessage.
        :type: list[str]
        """
        

        self._remote_ips = remote_ips

    @property
    def service_name(self) -> str:
        """
        Gets the service_name of this QualityAuditLogMessage.
        Name of the service that logged this audit message.

        :return: The service_name of this QualityAuditLogMessage.
        :rtype: str
        """
        return self._service_name

    @service_name.setter
    def service_name(self, service_name: str) -> None:
        """
        Sets the service_name of this QualityAuditLogMessage.
        Name of the service that logged this audit message.

        :param service_name: The service_name of this QualityAuditLogMessage.
        :type: str
        """
        if isinstance(service_name, int):
            service_name = str(service_name)
        allowed_values = ["RecordingService", "RecordingPlaybackService", "QualityService"]
        if service_name.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for service_name -> " + service_name)
            self._service_name = "outdated_sdk_version"
        else:
            self._service_name = service_name

    @property
    def level(self) -> str:
        """
        Gets the level of this QualityAuditLogMessage.
        The level of this audit message.

        :return: The level of this QualityAuditLogMessage.
        :rtype: str
        """
        return self._level

    @level.setter
    def level(self, level: str) -> None:
        """
        Sets the level of this QualityAuditLogMessage.
        The level of this audit message.

        :param level: The level of this QualityAuditLogMessage.
        :type: str
        """
        if isinstance(level, int):
            level = str(level)
        allowed_values = ["User", "System"]
        if level.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for level -> " + level)
            self._level = "outdated_sdk_version"
        else:
            self._level = level

    @property
    def status(self) -> str:
        """
        Gets the status of this QualityAuditLogMessage.
        The status of the action of this audit message.

        :return: The status of this QualityAuditLogMessage.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status: str) -> None:
        """
        Sets the status of this QualityAuditLogMessage.
        The status of the action of this audit message.

        :param status: The status of this QualityAuditLogMessage.
        :type: str
        """
        if isinstance(status, int):
            status = str(status)
        allowed_values = ["Success", "Failure", "Warning"]
        if status.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for status -> " + status)
            self._status = "outdated_sdk_version"
        else:
            self._status = status

    @property
    def event_date(self) -> datetime:
        """
        Gets the event_date of this QualityAuditLogMessage.
        Date and time of when the audit message was logged. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The event_date of this QualityAuditLogMessage.
        :rtype: datetime
        """
        return self._event_date

    @event_date.setter
    def event_date(self, event_date: datetime) -> None:
        """
        Sets the event_date of this QualityAuditLogMessage.
        Date and time of when the audit message was logged. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param event_date: The event_date of this QualityAuditLogMessage.
        :type: datetime
        """
        

        self._event_date = event_date

    @property
    def message_info(self) -> 'MessageInfo':
        """
        Gets the message_info of this QualityAuditLogMessage.
        Message describing the event being audited.

        :return: The message_info of this QualityAuditLogMessage.
        :rtype: MessageInfo
        """
        return self._message_info

    @message_info.setter
    def message_info(self, message_info: 'MessageInfo') -> None:
        """
        Sets the message_info of this QualityAuditLogMessage.
        Message describing the event being audited.

        :param message_info: The message_info of this QualityAuditLogMessage.
        :type: MessageInfo
        """
        

        self._message_info = message_info

    @property
    def action(self) -> str:
        """
        Gets the action of this QualityAuditLogMessage.
        Action that took place.

        :return: The action of this QualityAuditLogMessage.
        :rtype: str
        """
        return self._action

    @action.setter
    def action(self, action: str) -> None:
        """
        Sets the action of this QualityAuditLogMessage.
        Action that took place.

        :param action: The action of this QualityAuditLogMessage.
        :type: str
        """
        if isinstance(action, int):
            action = str(action)
        allowed_values = ["Read", "Create", "Update", "Delete", "Abandon", "Archive", "Export", "RestoreRequest", "RestoreComplete", "ApplyProtection", "RevokeProtection", "UpdateRetention"]
        if action.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for action -> " + action)
            self._action = "outdated_sdk_version"
        else:
            self._action = action

    @property
    def entity(self) -> 'DomainEntityRef':
        """
        Gets the entity of this QualityAuditLogMessage.
        Entity that was impacted.

        :return: The entity of this QualityAuditLogMessage.
        :rtype: DomainEntityRef
        """
        return self._entity

    @entity.setter
    def entity(self, entity: 'DomainEntityRef') -> None:
        """
        Sets the entity of this QualityAuditLogMessage.
        Entity that was impacted.

        :param entity: The entity of this QualityAuditLogMessage.
        :type: DomainEntityRef
        """
        

        self._entity = entity

    @property
    def entity_type(self) -> str:
        """
        Gets the entity_type of this QualityAuditLogMessage.
        Type of the entity that was impacted.

        :return: The entity_type of this QualityAuditLogMessage.
        :rtype: str
        """
        return self._entity_type

    @entity_type.setter
    def entity_type(self, entity_type: str) -> None:
        """
        Sets the entity_type of this QualityAuditLogMessage.
        Type of the entity that was impacted.

        :param entity_type: The entity_type of this QualityAuditLogMessage.
        :type: str
        """
        if isinstance(entity_type, int):
            entity_type = str(entity_type)
        allowed_values = ["Recording", "Evaluation", "Calibration", "Annotation", "ScreenRecording", "Survey"]
        if entity_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for entity_type -> " + entity_type)
            self._entity_type = "outdated_sdk_version"
        else:
            self._entity_type = entity_type

    @property
    def property_changes(self) -> List['PropertyChange']:
        """
        Gets the property_changes of this QualityAuditLogMessage.
        List of properties that were changed and changes made to those properties.

        :return: The property_changes of this QualityAuditLogMessage.
        :rtype: list[PropertyChange]
        """
        return self._property_changes

    @property_changes.setter
    def property_changes(self, property_changes: List['PropertyChange']) -> None:
        """
        Sets the property_changes of this QualityAuditLogMessage.
        List of properties that were changed and changes made to those properties.

        :param property_changes: The property_changes of this QualityAuditLogMessage.
        :type: list[PropertyChange]
        """
        

        self._property_changes = property_changes

    @property
    def context(self) -> Dict[str, str]:
        """
        Gets the context of this QualityAuditLogMessage.
        Additional context for this message.

        :return: The context of this QualityAuditLogMessage.
        :rtype: dict(str, str)
        """
        return self._context

    @context.setter
    def context(self, context: Dict[str, str]) -> None:
        """
        Sets the context of this QualityAuditLogMessage.
        Additional context for this message.

        :param context: The context of this QualityAuditLogMessage.
        :type: dict(str, str)
        """
        

        self._context = context

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

