# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import AddressableEntityRef
    from . import BaseProgramEntity

class ProgramMappings(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        ProgramMappings - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'program': 'BaseProgramEntity',
            'queues': 'list[AddressableEntityRef]',
            'flows': 'list[AddressableEntityRef]',
            'modified_by': 'AddressableEntityRef',
            'date_modified': 'datetime'
        }

        self.attribute_map = {
            'program': 'program',
            'queues': 'queues',
            'flows': 'flows',
            'modified_by': 'modifiedBy',
            'date_modified': 'dateModified'
        }

        self._program = None
        self._queues = None
        self._flows = None
        self._modified_by = None
        self._date_modified = None

    @property
    def program(self) -> 'BaseProgramEntity':
        """
        Gets the program of this ProgramMappings.


        :return: The program of this ProgramMappings.
        :rtype: BaseProgramEntity
        """
        return self._program

    @program.setter
    def program(self, program: 'BaseProgramEntity') -> None:
        """
        Sets the program of this ProgramMappings.


        :param program: The program of this ProgramMappings.
        :type: BaseProgramEntity
        """
        

        self._program = program

    @property
    def queues(self) -> List['AddressableEntityRef']:
        """
        Gets the queues of this ProgramMappings.


        :return: The queues of this ProgramMappings.
        :rtype: list[AddressableEntityRef]
        """
        return self._queues

    @queues.setter
    def queues(self, queues: List['AddressableEntityRef']) -> None:
        """
        Sets the queues of this ProgramMappings.


        :param queues: The queues of this ProgramMappings.
        :type: list[AddressableEntityRef]
        """
        

        self._queues = queues

    @property
    def flows(self) -> List['AddressableEntityRef']:
        """
        Gets the flows of this ProgramMappings.


        :return: The flows of this ProgramMappings.
        :rtype: list[AddressableEntityRef]
        """
        return self._flows

    @flows.setter
    def flows(self, flows: List['AddressableEntityRef']) -> None:
        """
        Sets the flows of this ProgramMappings.


        :param flows: The flows of this ProgramMappings.
        :type: list[AddressableEntityRef]
        """
        

        self._flows = flows

    @property
    def modified_by(self) -> 'AddressableEntityRef':
        """
        Gets the modified_by of this ProgramMappings.


        :return: The modified_by of this ProgramMappings.
        :rtype: AddressableEntityRef
        """
        return self._modified_by

    @modified_by.setter
    def modified_by(self, modified_by: 'AddressableEntityRef') -> None:
        """
        Sets the modified_by of this ProgramMappings.


        :param modified_by: The modified_by of this ProgramMappings.
        :type: AddressableEntityRef
        """
        

        self._modified_by = modified_by

    @property
    def date_modified(self) -> datetime:
        """
        Gets the date_modified of this ProgramMappings.
        Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_modified of this ProgramMappings.
        :rtype: datetime
        """
        return self._date_modified

    @date_modified.setter
    def date_modified(self, date_modified: datetime) -> None:
        """
        Sets the date_modified of this ProgramMappings.
        Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_modified: The date_modified of this ProgramMappings.
        :type: datetime
        """
        

        self._date_modified = date_modified

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

