# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import OutboundMessagingMessagingCampaignConfigChangeFromEmailAddress
    from . import OutboundMessagingMessagingCampaignConfigChangeReplyToEmailAddress
    from . import OutboundMessagingMessagingCampaignConfigChangeResponseRef

class OutboundMessagingMessagingCampaignConfigChangeEmailConfig(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        OutboundMessagingMessagingCampaignConfigChangeEmailConfig - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'email_columns': 'list[str]',
            'content_template': 'OutboundMessagingMessagingCampaignConfigChangeResponseRef',
            'from_address': 'OutboundMessagingMessagingCampaignConfigChangeFromEmailAddress',
            'reply_to_address': 'OutboundMessagingMessagingCampaignConfigChangeReplyToEmailAddress'
        }

        self.attribute_map = {
            'email_columns': 'emailColumns',
            'content_template': 'contentTemplate',
            'from_address': 'fromAddress',
            'reply_to_address': 'replyToAddress'
        }

        self._email_columns = None
        self._content_template = None
        self._from_address = None
        self._reply_to_address = None

    @property
    def email_columns(self) -> List[str]:
        """
        Gets the email_columns of this OutboundMessagingMessagingCampaignConfigChangeEmailConfig.
        The Contact List column specifying the email to send to the contact.

        :return: The email_columns of this OutboundMessagingMessagingCampaignConfigChangeEmailConfig.
        :rtype: list[str]
        """
        return self._email_columns

    @email_columns.setter
    def email_columns(self, email_columns: List[str]) -> None:
        """
        Sets the email_columns of this OutboundMessagingMessagingCampaignConfigChangeEmailConfig.
        The Contact List column specifying the email to send to the contact.

        :param email_columns: The email_columns of this OutboundMessagingMessagingCampaignConfigChangeEmailConfig.
        :type: list[str]
        """
        

        self._email_columns = email_columns

    @property
    def content_template(self) -> 'OutboundMessagingMessagingCampaignConfigChangeResponseRef':
        """
        Gets the content_template of this OutboundMessagingMessagingCampaignConfigChangeEmailConfig.
        A reference for a Response

        :return: The content_template of this OutboundMessagingMessagingCampaignConfigChangeEmailConfig.
        :rtype: OutboundMessagingMessagingCampaignConfigChangeResponseRef
        """
        return self._content_template

    @content_template.setter
    def content_template(self, content_template: 'OutboundMessagingMessagingCampaignConfigChangeResponseRef') -> None:
        """
        Sets the content_template of this OutboundMessagingMessagingCampaignConfigChangeEmailConfig.
        A reference for a Response

        :param content_template: The content_template of this OutboundMessagingMessagingCampaignConfigChangeEmailConfig.
        :type: OutboundMessagingMessagingCampaignConfigChangeResponseRef
        """
        

        self._content_template = content_template

    @property
    def from_address(self) -> 'OutboundMessagingMessagingCampaignConfigChangeFromEmailAddress':
        """
        Gets the from_address of this OutboundMessagingMessagingCampaignConfigChangeEmailConfig.


        :return: The from_address of this OutboundMessagingMessagingCampaignConfigChangeEmailConfig.
        :rtype: OutboundMessagingMessagingCampaignConfigChangeFromEmailAddress
        """
        return self._from_address

    @from_address.setter
    def from_address(self, from_address: 'OutboundMessagingMessagingCampaignConfigChangeFromEmailAddress') -> None:
        """
        Sets the from_address of this OutboundMessagingMessagingCampaignConfigChangeEmailConfig.


        :param from_address: The from_address of this OutboundMessagingMessagingCampaignConfigChangeEmailConfig.
        :type: OutboundMessagingMessagingCampaignConfigChangeFromEmailAddress
        """
        

        self._from_address = from_address

    @property
    def reply_to_address(self) -> 'OutboundMessagingMessagingCampaignConfigChangeReplyToEmailAddress':
        """
        Gets the reply_to_address of this OutboundMessagingMessagingCampaignConfigChangeEmailConfig.


        :return: The reply_to_address of this OutboundMessagingMessagingCampaignConfigChangeEmailConfig.
        :rtype: OutboundMessagingMessagingCampaignConfigChangeReplyToEmailAddress
        """
        return self._reply_to_address

    @reply_to_address.setter
    def reply_to_address(self, reply_to_address: 'OutboundMessagingMessagingCampaignConfigChangeReplyToEmailAddress') -> None:
        """
        Sets the reply_to_address of this OutboundMessagingMessagingCampaignConfigChangeEmailConfig.


        :param reply_to_address: The reply_to_address of this OutboundMessagingMessagingCampaignConfigChangeEmailConfig.
        :type: OutboundMessagingMessagingCampaignConfigChangeReplyToEmailAddress
        """
        

        self._reply_to_address = reply_to_address

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

