# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import NluDetectionInput
    from . import NluDetectionOutput
    from . import NluDomainVersion

class NluDetectionResponse(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        NluDetectionResponse - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'version': 'NluDomainVersion',
            'output': 'NluDetectionOutput',
            'input': 'NluDetectionInput'
        }

        self.attribute_map = {
            'version': 'version',
            'output': 'output',
            'input': 'input'
        }

        self._version = None
        self._output = None
        self._input = None

    @property
    def version(self) -> 'NluDomainVersion':
        """
        Gets the version of this NluDetectionResponse.
        The NLU domain version which performed the detection.

        :return: The version of this NluDetectionResponse.
        :rtype: NluDomainVersion
        """
        return self._version

    @version.setter
    def version(self, version: 'NluDomainVersion') -> None:
        """
        Sets the version of this NluDetectionResponse.
        The NLU domain version which performed the detection.

        :param version: The version of this NluDetectionResponse.
        :type: NluDomainVersion
        """
        

        self._version = version

    @property
    def output(self) -> 'NluDetectionOutput':
        """
        Gets the output of this NluDetectionResponse.


        :return: The output of this NluDetectionResponse.
        :rtype: NluDetectionOutput
        """
        return self._output

    @output.setter
    def output(self, output: 'NluDetectionOutput') -> None:
        """
        Sets the output of this NluDetectionResponse.


        :param output: The output of this NluDetectionResponse.
        :type: NluDetectionOutput
        """
        

        self._output = output

    @property
    def input(self) -> 'NluDetectionInput':
        """
        Gets the input of this NluDetectionResponse.


        :return: The input of this NluDetectionResponse.
        :rtype: NluDetectionInput
        """
        return self._input

    @input.setter
    def input(self, input: 'NluDetectionInput') -> None:
        """
        Sets the input of this NluDetectionResponse.


        :param input: The input of this NluDetectionResponse.
        :type: NluDetectionInput
        """
        

        self._input = input

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

