# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import WrapupInput

class MediaParticipantRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        MediaParticipantRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'wrapup': 'WrapupInput',
            'state': 'str',
            'recording': 'bool',
            'muted': 'bool',
            'confined': 'bool',
            'held': 'bool',
            'wrapup_skipped': 'bool'
        }

        self.attribute_map = {
            'wrapup': 'wrapup',
            'state': 'state',
            'recording': 'recording',
            'muted': 'muted',
            'confined': 'confined',
            'held': 'held',
            'wrapup_skipped': 'wrapupSkipped'
        }

        self._wrapup = None
        self._state = None
        self._recording = None
        self._muted = None
        self._confined = None
        self._held = None
        self._wrapup_skipped = None

    @property
    def wrapup(self) -> 'WrapupInput':
        """
        Gets the wrapup of this MediaParticipantRequest.
        Wrap-up to assign to this participant.

        :return: The wrapup of this MediaParticipantRequest.
        :rtype: WrapupInput
        """
        return self._wrapup

    @wrapup.setter
    def wrapup(self, wrapup: 'WrapupInput') -> None:
        """
        Sets the wrapup of this MediaParticipantRequest.
        Wrap-up to assign to this participant.

        :param wrapup: The wrapup of this MediaParticipantRequest.
        :type: WrapupInput
        """
        

        self._wrapup = wrapup

    @property
    def state(self) -> str:
        """
        Gets the state of this MediaParticipantRequest.
        The state to update to set for this participant's communications.  Possible values are: 'connected' and 'disconnected'.

        :return: The state of this MediaParticipantRequest.
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state: str) -> None:
        """
        Sets the state of this MediaParticipantRequest.
        The state to update to set for this participant's communications.  Possible values are: 'connected' and 'disconnected'.

        :param state: The state of this MediaParticipantRequest.
        :type: str
        """
        if isinstance(state, int):
            state = str(state)
        allowed_values = ["alerting", "dialing", "contacting", "offering", "connected", "disconnected", "terminated", "converting", "uploading", "transmitting", "none"]
        if state.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for state -> " + state)
            self._state = "outdated_sdk_version"
        else:
            self._state = state

    @property
    def recording(self) -> bool:
        """
        Gets the recording of this MediaParticipantRequest.
        True to enable recording of this participant, otherwise false to disable recording.

        :return: The recording of this MediaParticipantRequest.
        :rtype: bool
        """
        return self._recording

    @recording.setter
    def recording(self, recording: bool) -> None:
        """
        Sets the recording of this MediaParticipantRequest.
        True to enable recording of this participant, otherwise false to disable recording.

        :param recording: The recording of this MediaParticipantRequest.
        :type: bool
        """
        

        self._recording = recording

    @property
    def muted(self) -> bool:
        """
        Gets the muted of this MediaParticipantRequest.
        True to mute this conversation participant.

        :return: The muted of this MediaParticipantRequest.
        :rtype: bool
        """
        return self._muted

    @muted.setter
    def muted(self, muted: bool) -> None:
        """
        Sets the muted of this MediaParticipantRequest.
        True to mute this conversation participant.

        :param muted: The muted of this MediaParticipantRequest.
        :type: bool
        """
        

        self._muted = muted

    @property
    def confined(self) -> bool:
        """
        Gets the confined of this MediaParticipantRequest.
        True to confine this conversation participant.  Should only be used for ad-hoc conferences

        :return: The confined of this MediaParticipantRequest.
        :rtype: bool
        """
        return self._confined

    @confined.setter
    def confined(self, confined: bool) -> None:
        """
        Sets the confined of this MediaParticipantRequest.
        True to confine this conversation participant.  Should only be used for ad-hoc conferences

        :param confined: The confined of this MediaParticipantRequest.
        :type: bool
        """
        

        self._confined = confined

    @property
    def held(self) -> bool:
        """
        Gets the held of this MediaParticipantRequest.
        True to hold this conversation participant.

        :return: The held of this MediaParticipantRequest.
        :rtype: bool
        """
        return self._held

    @held.setter
    def held(self, held: bool) -> None:
        """
        Sets the held of this MediaParticipantRequest.
        True to hold this conversation participant.

        :param held: The held of this MediaParticipantRequest.
        :type: bool
        """
        

        self._held = held

    @property
    def wrapup_skipped(self) -> bool:
        """
        Gets the wrapup_skipped of this MediaParticipantRequest.
        True to skip wrap-up for this participant.

        :return: The wrapup_skipped of this MediaParticipantRequest.
        :rtype: bool
        """
        return self._wrapup_skipped

    @wrapup_skipped.setter
    def wrapup_skipped(self, wrapup_skipped: bool) -> None:
        """
        Sets the wrapup_skipped of this MediaParticipantRequest.
        True to skip wrap-up for this participant.

        :param wrapup_skipped: The wrapup_skipped of this MediaParticipantRequest.
        :type: bool
        """
        

        self._wrapup_skipped = wrapup_skipped

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

