# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import LearningAssignmentTopicLearningModuleReference
    from . import LearningAssignmentTopicUserReference

class LearningAssignmentTopicLearningAssignmentNotification(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        LearningAssignmentTopicLearningAssignmentNotification - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'user': 'LearningAssignmentTopicUserReference',
            'module': 'LearningAssignmentTopicLearningModuleReference',
            'version': 'int',
            'state': 'str',
            'date_recommended_for_completion': 'datetime',
            'created_by': 'LearningAssignmentTopicUserReference',
            'date_created': 'datetime',
            'modified_by': 'LearningAssignmentTopicUserReference',
            'date_modified': 'datetime',
            'is_overdue': 'bool',
            'length_in_minutes': 'int'
        }

        self.attribute_map = {
            'id': 'id',
            'user': 'user',
            'module': 'module',
            'version': 'version',
            'state': 'state',
            'date_recommended_for_completion': 'dateRecommendedForCompletion',
            'created_by': 'createdBy',
            'date_created': 'dateCreated',
            'modified_by': 'modifiedBy',
            'date_modified': 'dateModified',
            'is_overdue': 'isOverdue',
            'length_in_minutes': 'lengthInMinutes'
        }

        self._id = None
        self._user = None
        self._module = None
        self._version = None
        self._state = None
        self._date_recommended_for_completion = None
        self._created_by = None
        self._date_created = None
        self._modified_by = None
        self._date_modified = None
        self._is_overdue = None
        self._length_in_minutes = None

    @property
    def id(self) -> str:
        """
        Gets the id of this LearningAssignmentTopicLearningAssignmentNotification.


        :return: The id of this LearningAssignmentTopicLearningAssignmentNotification.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this LearningAssignmentTopicLearningAssignmentNotification.


        :param id: The id of this LearningAssignmentTopicLearningAssignmentNotification.
        :type: str
        """
        

        self._id = id

    @property
    def user(self) -> 'LearningAssignmentTopicUserReference':
        """
        Gets the user of this LearningAssignmentTopicLearningAssignmentNotification.


        :return: The user of this LearningAssignmentTopicLearningAssignmentNotification.
        :rtype: LearningAssignmentTopicUserReference
        """
        return self._user

    @user.setter
    def user(self, user: 'LearningAssignmentTopicUserReference') -> None:
        """
        Sets the user of this LearningAssignmentTopicLearningAssignmentNotification.


        :param user: The user of this LearningAssignmentTopicLearningAssignmentNotification.
        :type: LearningAssignmentTopicUserReference
        """
        

        self._user = user

    @property
    def module(self) -> 'LearningAssignmentTopicLearningModuleReference':
        """
        Gets the module of this LearningAssignmentTopicLearningAssignmentNotification.


        :return: The module of this LearningAssignmentTopicLearningAssignmentNotification.
        :rtype: LearningAssignmentTopicLearningModuleReference
        """
        return self._module

    @module.setter
    def module(self, module: 'LearningAssignmentTopicLearningModuleReference') -> None:
        """
        Sets the module of this LearningAssignmentTopicLearningAssignmentNotification.


        :param module: The module of this LearningAssignmentTopicLearningAssignmentNotification.
        :type: LearningAssignmentTopicLearningModuleReference
        """
        

        self._module = module

    @property
    def version(self) -> int:
        """
        Gets the version of this LearningAssignmentTopicLearningAssignmentNotification.


        :return: The version of this LearningAssignmentTopicLearningAssignmentNotification.
        :rtype: int
        """
        return self._version

    @version.setter
    def version(self, version: int) -> None:
        """
        Sets the version of this LearningAssignmentTopicLearningAssignmentNotification.


        :param version: The version of this LearningAssignmentTopicLearningAssignmentNotification.
        :type: int
        """
        

        self._version = version

    @property
    def state(self) -> str:
        """
        Gets the state of this LearningAssignmentTopicLearningAssignmentNotification.


        :return: The state of this LearningAssignmentTopicLearningAssignmentNotification.
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state: str) -> None:
        """
        Sets the state of this LearningAssignmentTopicLearningAssignmentNotification.


        :param state: The state of this LearningAssignmentTopicLearningAssignmentNotification.
        :type: str
        """
        if isinstance(state, int):
            state = str(state)
        allowed_values = ["Assigned", "InProgress", "Completed", "Deleted", "NotCompleted", "InvalidSchedule"]
        if state.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for state -> " + state)
            self._state = "outdated_sdk_version"
        else:
            self._state = state

    @property
    def date_recommended_for_completion(self) -> datetime:
        """
        Gets the date_recommended_for_completion of this LearningAssignmentTopicLearningAssignmentNotification.


        :return: The date_recommended_for_completion of this LearningAssignmentTopicLearningAssignmentNotification.
        :rtype: datetime
        """
        return self._date_recommended_for_completion

    @date_recommended_for_completion.setter
    def date_recommended_for_completion(self, date_recommended_for_completion: datetime) -> None:
        """
        Sets the date_recommended_for_completion of this LearningAssignmentTopicLearningAssignmentNotification.


        :param date_recommended_for_completion: The date_recommended_for_completion of this LearningAssignmentTopicLearningAssignmentNotification.
        :type: datetime
        """
        

        self._date_recommended_for_completion = date_recommended_for_completion

    @property
    def created_by(self) -> 'LearningAssignmentTopicUserReference':
        """
        Gets the created_by of this LearningAssignmentTopicLearningAssignmentNotification.


        :return: The created_by of this LearningAssignmentTopicLearningAssignmentNotification.
        :rtype: LearningAssignmentTopicUserReference
        """
        return self._created_by

    @created_by.setter
    def created_by(self, created_by: 'LearningAssignmentTopicUserReference') -> None:
        """
        Sets the created_by of this LearningAssignmentTopicLearningAssignmentNotification.


        :param created_by: The created_by of this LearningAssignmentTopicLearningAssignmentNotification.
        :type: LearningAssignmentTopicUserReference
        """
        

        self._created_by = created_by

    @property
    def date_created(self) -> datetime:
        """
        Gets the date_created of this LearningAssignmentTopicLearningAssignmentNotification.


        :return: The date_created of this LearningAssignmentTopicLearningAssignmentNotification.
        :rtype: datetime
        """
        return self._date_created

    @date_created.setter
    def date_created(self, date_created: datetime) -> None:
        """
        Sets the date_created of this LearningAssignmentTopicLearningAssignmentNotification.


        :param date_created: The date_created of this LearningAssignmentTopicLearningAssignmentNotification.
        :type: datetime
        """
        

        self._date_created = date_created

    @property
    def modified_by(self) -> 'LearningAssignmentTopicUserReference':
        """
        Gets the modified_by of this LearningAssignmentTopicLearningAssignmentNotification.


        :return: The modified_by of this LearningAssignmentTopicLearningAssignmentNotification.
        :rtype: LearningAssignmentTopicUserReference
        """
        return self._modified_by

    @modified_by.setter
    def modified_by(self, modified_by: 'LearningAssignmentTopicUserReference') -> None:
        """
        Sets the modified_by of this LearningAssignmentTopicLearningAssignmentNotification.


        :param modified_by: The modified_by of this LearningAssignmentTopicLearningAssignmentNotification.
        :type: LearningAssignmentTopicUserReference
        """
        

        self._modified_by = modified_by

    @property
    def date_modified(self) -> datetime:
        """
        Gets the date_modified of this LearningAssignmentTopicLearningAssignmentNotification.


        :return: The date_modified of this LearningAssignmentTopicLearningAssignmentNotification.
        :rtype: datetime
        """
        return self._date_modified

    @date_modified.setter
    def date_modified(self, date_modified: datetime) -> None:
        """
        Sets the date_modified of this LearningAssignmentTopicLearningAssignmentNotification.


        :param date_modified: The date_modified of this LearningAssignmentTopicLearningAssignmentNotification.
        :type: datetime
        """
        

        self._date_modified = date_modified

    @property
    def is_overdue(self) -> bool:
        """
        Gets the is_overdue of this LearningAssignmentTopicLearningAssignmentNotification.


        :return: The is_overdue of this LearningAssignmentTopicLearningAssignmentNotification.
        :rtype: bool
        """
        return self._is_overdue

    @is_overdue.setter
    def is_overdue(self, is_overdue: bool) -> None:
        """
        Sets the is_overdue of this LearningAssignmentTopicLearningAssignmentNotification.


        :param is_overdue: The is_overdue of this LearningAssignmentTopicLearningAssignmentNotification.
        :type: bool
        """
        

        self._is_overdue = is_overdue

    @property
    def length_in_minutes(self) -> int:
        """
        Gets the length_in_minutes of this LearningAssignmentTopicLearningAssignmentNotification.


        :return: The length_in_minutes of this LearningAssignmentTopicLearningAssignmentNotification.
        :rtype: int
        """
        return self._length_in_minutes

    @length_in_minutes.setter
    def length_in_minutes(self, length_in_minutes: int) -> None:
        """
        Sets the length_in_minutes of this LearningAssignmentTopicLearningAssignmentNotification.


        :param length_in_minutes: The length_in_minutes of this LearningAssignmentTopicLearningAssignmentNotification.
        :type: int
        """
        

        self._length_in_minutes = length_in_minutes

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

