# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import KnowledgeGuestSessionApp
    from . import KnowledgeGuestSessionContext

class KnowledgeGuestSession(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        KnowledgeGuestSession - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'app': 'KnowledgeGuestSessionApp',
            'customer_id': 'str',
            'page_url': 'str',
            'contexts': 'list[KnowledgeGuestSessionContext]'
        }

        self.attribute_map = {
            'id': 'id',
            'app': 'app',
            'customer_id': 'customerId',
            'page_url': 'pageUrl',
            'contexts': 'contexts'
        }

        self._id = None
        self._app = None
        self._customer_id = None
        self._page_url = None
        self._contexts = None

    @property
    def id(self) -> str:
        """
        Gets the id of this KnowledgeGuestSession.
        Session ID.

        :return: The id of this KnowledgeGuestSession.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this KnowledgeGuestSession.
        Session ID.

        :param id: The id of this KnowledgeGuestSession.
        :type: str
        """
        

        self._id = id

    @property
    def app(self) -> 'KnowledgeGuestSessionApp':
        """
        Gets the app of this KnowledgeGuestSession.
        The app where the session is started.

        :return: The app of this KnowledgeGuestSession.
        :rtype: KnowledgeGuestSessionApp
        """
        return self._app

    @app.setter
    def app(self, app: 'KnowledgeGuestSessionApp') -> None:
        """
        Sets the app of this KnowledgeGuestSession.
        The app where the session is started.

        :param app: The app of this KnowledgeGuestSession.
        :type: KnowledgeGuestSessionApp
        """
        

        self._app = app

    @property
    def customer_id(self) -> str:
        """
        Gets the customer_id of this KnowledgeGuestSession.
        An arbitrary ID for the customer starting the session. Used to track multiple sessions started by the same customer.

        :return: The customer_id of this KnowledgeGuestSession.
        :rtype: str
        """
        return self._customer_id

    @customer_id.setter
    def customer_id(self, customer_id: str) -> None:
        """
        Sets the customer_id of this KnowledgeGuestSession.
        An arbitrary ID for the customer starting the session. Used to track multiple sessions started by the same customer.

        :param customer_id: The customer_id of this KnowledgeGuestSession.
        :type: str
        """
        

        self._customer_id = customer_id

    @property
    def page_url(self) -> str:
        """
        Gets the page_url of this KnowledgeGuestSession.
        URL of the page where the session is started.

        :return: The page_url of this KnowledgeGuestSession.
        :rtype: str
        """
        return self._page_url

    @page_url.setter
    def page_url(self, page_url: str) -> None:
        """
        Sets the page_url of this KnowledgeGuestSession.
        URL of the page where the session is started.

        :param page_url: The page_url of this KnowledgeGuestSession.
        :type: str
        """
        

        self._page_url = page_url

    @property
    def contexts(self) -> List['KnowledgeGuestSessionContext']:
        """
        Gets the contexts of this KnowledgeGuestSession.
        The session contexts.

        :return: The contexts of this KnowledgeGuestSession.
        :rtype: list[KnowledgeGuestSessionContext]
        """
        return self._contexts

    @contexts.setter
    def contexts(self, contexts: List['KnowledgeGuestSessionContext']) -> None:
        """
        Sets the contexts of this KnowledgeGuestSession.
        The session contexts.

        :param contexts: The contexts of this KnowledgeGuestSession.
        :type: list[KnowledgeGuestSessionContext]
        """
        

        self._contexts = contexts

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

