# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import JourneySessionEventsNotificationBrowser
    from . import JourneySessionEventsNotificationConnectedQueue
    from . import JourneySessionEventsNotificationConversation
    from . import JourneySessionEventsNotificationConversationChannel
    from . import JourneySessionEventsNotificationConversationUserDisposition
    from . import JourneySessionEventsNotificationDevice
    from . import JourneySessionEventsNotificationExternalContact
    from . import JourneySessionEventsNotificationGeoLocation
    from . import JourneySessionEventsNotificationMktCampaign
    from . import JourneySessionEventsNotificationOutcomeAchievement
    from . import JourneySessionEventsNotificationPage
    from . import JourneySessionEventsNotificationReferrer
    from . import JourneySessionEventsNotificationSegmentAssignment
    from . import JourneySessionEventsNotificationSessionLastEvent
    from . import JourneySessionEventsNotificationUser

class JourneySessionEventsNotificationSessionEvent(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        JourneySessionEventsNotificationSessionEvent - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'self_uri': 'str',
            'created_date': 'datetime',
            'ended_date': 'datetime',
            'external_contact': 'JourneySessionEventsNotificationExternalContact',
            'customer_id': 'str',
            'customer_id_type': 'str',
            'type': 'str',
            'outcome_achievements': 'list[JourneySessionEventsNotificationOutcomeAchievement]',
            'segment_assignments': 'list[JourneySessionEventsNotificationSegmentAssignment]',
            'away_date': 'datetime',
            'browser': 'JourneySessionEventsNotificationBrowser',
            'device': 'JourneySessionEventsNotificationDevice',
            'geolocation': 'JourneySessionEventsNotificationGeoLocation',
            'idle_date': 'datetime',
            'ip_address': 'str',
            'ip_organization': 'str',
            'last_page': 'JourneySessionEventsNotificationPage',
            'mkt_campaign': 'JourneySessionEventsNotificationMktCampaign',
            'referrer': 'JourneySessionEventsNotificationReferrer',
            'search_terms': 'list[str]',
            'user_agent_string': 'str',
            'duration_in_seconds': 'int',
            'event_count': 'int',
            'pageview_count': 'int',
            'screenview_count': 'int',
            'last_event': 'JourneySessionEventsNotificationSessionLastEvent',
            'conversation': 'JourneySessionEventsNotificationConversation',
            'originating_direction': 'str',
            'conversation_subject': 'str',
            'last_user_disposition': 'JourneySessionEventsNotificationConversationUserDisposition',
            'last_connected_user': 'JourneySessionEventsNotificationUser',
            'last_connected_queue': 'JourneySessionEventsNotificationConnectedQueue',
            'conversation_channels': 'list[JourneySessionEventsNotificationConversationChannel]',
            'last_user_disconnect_type': 'str',
            'last_acd_outcome': 'str',
            'authenticated': 'bool'
        }

        self.attribute_map = {
            'id': 'id',
            'self_uri': 'selfUri',
            'created_date': 'createdDate',
            'ended_date': 'endedDate',
            'external_contact': 'externalContact',
            'customer_id': 'customerId',
            'customer_id_type': 'customerIdType',
            'type': 'type',
            'outcome_achievements': 'outcomeAchievements',
            'segment_assignments': 'segmentAssignments',
            'away_date': 'awayDate',
            'browser': 'browser',
            'device': 'device',
            'geolocation': 'geolocation',
            'idle_date': 'idleDate',
            'ip_address': 'ipAddress',
            'ip_organization': 'ipOrganization',
            'last_page': 'lastPage',
            'mkt_campaign': 'mktCampaign',
            'referrer': 'referrer',
            'search_terms': 'searchTerms',
            'user_agent_string': 'userAgentString',
            'duration_in_seconds': 'durationInSeconds',
            'event_count': 'eventCount',
            'pageview_count': 'pageviewCount',
            'screenview_count': 'screenviewCount',
            'last_event': 'lastEvent',
            'conversation': 'conversation',
            'originating_direction': 'originatingDirection',
            'conversation_subject': 'conversationSubject',
            'last_user_disposition': 'lastUserDisposition',
            'last_connected_user': 'lastConnectedUser',
            'last_connected_queue': 'lastConnectedQueue',
            'conversation_channels': 'conversationChannels',
            'last_user_disconnect_type': 'lastUserDisconnectType',
            'last_acd_outcome': 'lastAcdOutcome',
            'authenticated': 'authenticated'
        }

        self._id = None
        self._self_uri = None
        self._created_date = None
        self._ended_date = None
        self._external_contact = None
        self._customer_id = None
        self._customer_id_type = None
        self._type = None
        self._outcome_achievements = None
        self._segment_assignments = None
        self._away_date = None
        self._browser = None
        self._device = None
        self._geolocation = None
        self._idle_date = None
        self._ip_address = None
        self._ip_organization = None
        self._last_page = None
        self._mkt_campaign = None
        self._referrer = None
        self._search_terms = None
        self._user_agent_string = None
        self._duration_in_seconds = None
        self._event_count = None
        self._pageview_count = None
        self._screenview_count = None
        self._last_event = None
        self._conversation = None
        self._originating_direction = None
        self._conversation_subject = None
        self._last_user_disposition = None
        self._last_connected_user = None
        self._last_connected_queue = None
        self._conversation_channels = None
        self._last_user_disconnect_type = None
        self._last_acd_outcome = None
        self._authenticated = None

    @property
    def id(self) -> str:
        """
        Gets the id of this JourneySessionEventsNotificationSessionEvent.


        :return: The id of this JourneySessionEventsNotificationSessionEvent.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this JourneySessionEventsNotificationSessionEvent.


        :param id: The id of this JourneySessionEventsNotificationSessionEvent.
        :type: str
        """
        

        self._id = id

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this JourneySessionEventsNotificationSessionEvent.


        :return: The self_uri of this JourneySessionEventsNotificationSessionEvent.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this JourneySessionEventsNotificationSessionEvent.


        :param self_uri: The self_uri of this JourneySessionEventsNotificationSessionEvent.
        :type: str
        """
        

        self._self_uri = self_uri

    @property
    def created_date(self) -> datetime:
        """
        Gets the created_date of this JourneySessionEventsNotificationSessionEvent.


        :return: The created_date of this JourneySessionEventsNotificationSessionEvent.
        :rtype: datetime
        """
        return self._created_date

    @created_date.setter
    def created_date(self, created_date: datetime) -> None:
        """
        Sets the created_date of this JourneySessionEventsNotificationSessionEvent.


        :param created_date: The created_date of this JourneySessionEventsNotificationSessionEvent.
        :type: datetime
        """
        

        self._created_date = created_date

    @property
    def ended_date(self) -> datetime:
        """
        Gets the ended_date of this JourneySessionEventsNotificationSessionEvent.


        :return: The ended_date of this JourneySessionEventsNotificationSessionEvent.
        :rtype: datetime
        """
        return self._ended_date

    @ended_date.setter
    def ended_date(self, ended_date: datetime) -> None:
        """
        Sets the ended_date of this JourneySessionEventsNotificationSessionEvent.


        :param ended_date: The ended_date of this JourneySessionEventsNotificationSessionEvent.
        :type: datetime
        """
        

        self._ended_date = ended_date

    @property
    def external_contact(self) -> 'JourneySessionEventsNotificationExternalContact':
        """
        Gets the external_contact of this JourneySessionEventsNotificationSessionEvent.


        :return: The external_contact of this JourneySessionEventsNotificationSessionEvent.
        :rtype: JourneySessionEventsNotificationExternalContact
        """
        return self._external_contact

    @external_contact.setter
    def external_contact(self, external_contact: 'JourneySessionEventsNotificationExternalContact') -> None:
        """
        Sets the external_contact of this JourneySessionEventsNotificationSessionEvent.


        :param external_contact: The external_contact of this JourneySessionEventsNotificationSessionEvent.
        :type: JourneySessionEventsNotificationExternalContact
        """
        

        self._external_contact = external_contact

    @property
    def customer_id(self) -> str:
        """
        Gets the customer_id of this JourneySessionEventsNotificationSessionEvent.


        :return: The customer_id of this JourneySessionEventsNotificationSessionEvent.
        :rtype: str
        """
        return self._customer_id

    @customer_id.setter
    def customer_id(self, customer_id: str) -> None:
        """
        Sets the customer_id of this JourneySessionEventsNotificationSessionEvent.


        :param customer_id: The customer_id of this JourneySessionEventsNotificationSessionEvent.
        :type: str
        """
        

        self._customer_id = customer_id

    @property
    def customer_id_type(self) -> str:
        """
        Gets the customer_id_type of this JourneySessionEventsNotificationSessionEvent.


        :return: The customer_id_type of this JourneySessionEventsNotificationSessionEvent.
        :rtype: str
        """
        return self._customer_id_type

    @customer_id_type.setter
    def customer_id_type(self, customer_id_type: str) -> None:
        """
        Sets the customer_id_type of this JourneySessionEventsNotificationSessionEvent.


        :param customer_id_type: The customer_id_type of this JourneySessionEventsNotificationSessionEvent.
        :type: str
        """
        

        self._customer_id_type = customer_id_type

    @property
    def type(self) -> str:
        """
        Gets the type of this JourneySessionEventsNotificationSessionEvent.


        :return: The type of this JourneySessionEventsNotificationSessionEvent.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type: str) -> None:
        """
        Sets the type of this JourneySessionEventsNotificationSessionEvent.


        :param type: The type of this JourneySessionEventsNotificationSessionEvent.
        :type: str
        """
        

        self._type = type

    @property
    def outcome_achievements(self) -> List['JourneySessionEventsNotificationOutcomeAchievement']:
        """
        Gets the outcome_achievements of this JourneySessionEventsNotificationSessionEvent.


        :return: The outcome_achievements of this JourneySessionEventsNotificationSessionEvent.
        :rtype: list[JourneySessionEventsNotificationOutcomeAchievement]
        """
        return self._outcome_achievements

    @outcome_achievements.setter
    def outcome_achievements(self, outcome_achievements: List['JourneySessionEventsNotificationOutcomeAchievement']) -> None:
        """
        Sets the outcome_achievements of this JourneySessionEventsNotificationSessionEvent.


        :param outcome_achievements: The outcome_achievements of this JourneySessionEventsNotificationSessionEvent.
        :type: list[JourneySessionEventsNotificationOutcomeAchievement]
        """
        

        self._outcome_achievements = outcome_achievements

    @property
    def segment_assignments(self) -> List['JourneySessionEventsNotificationSegmentAssignment']:
        """
        Gets the segment_assignments of this JourneySessionEventsNotificationSessionEvent.


        :return: The segment_assignments of this JourneySessionEventsNotificationSessionEvent.
        :rtype: list[JourneySessionEventsNotificationSegmentAssignment]
        """
        return self._segment_assignments

    @segment_assignments.setter
    def segment_assignments(self, segment_assignments: List['JourneySessionEventsNotificationSegmentAssignment']) -> None:
        """
        Sets the segment_assignments of this JourneySessionEventsNotificationSessionEvent.


        :param segment_assignments: The segment_assignments of this JourneySessionEventsNotificationSessionEvent.
        :type: list[JourneySessionEventsNotificationSegmentAssignment]
        """
        

        self._segment_assignments = segment_assignments

    @property
    def away_date(self) -> datetime:
        """
        Gets the away_date of this JourneySessionEventsNotificationSessionEvent.


        :return: The away_date of this JourneySessionEventsNotificationSessionEvent.
        :rtype: datetime
        """
        return self._away_date

    @away_date.setter
    def away_date(self, away_date: datetime) -> None:
        """
        Sets the away_date of this JourneySessionEventsNotificationSessionEvent.


        :param away_date: The away_date of this JourneySessionEventsNotificationSessionEvent.
        :type: datetime
        """
        

        self._away_date = away_date

    @property
    def browser(self) -> 'JourneySessionEventsNotificationBrowser':
        """
        Gets the browser of this JourneySessionEventsNotificationSessionEvent.


        :return: The browser of this JourneySessionEventsNotificationSessionEvent.
        :rtype: JourneySessionEventsNotificationBrowser
        """
        return self._browser

    @browser.setter
    def browser(self, browser: 'JourneySessionEventsNotificationBrowser') -> None:
        """
        Sets the browser of this JourneySessionEventsNotificationSessionEvent.


        :param browser: The browser of this JourneySessionEventsNotificationSessionEvent.
        :type: JourneySessionEventsNotificationBrowser
        """
        

        self._browser = browser

    @property
    def device(self) -> 'JourneySessionEventsNotificationDevice':
        """
        Gets the device of this JourneySessionEventsNotificationSessionEvent.


        :return: The device of this JourneySessionEventsNotificationSessionEvent.
        :rtype: JourneySessionEventsNotificationDevice
        """
        return self._device

    @device.setter
    def device(self, device: 'JourneySessionEventsNotificationDevice') -> None:
        """
        Sets the device of this JourneySessionEventsNotificationSessionEvent.


        :param device: The device of this JourneySessionEventsNotificationSessionEvent.
        :type: JourneySessionEventsNotificationDevice
        """
        

        self._device = device

    @property
    def geolocation(self) -> 'JourneySessionEventsNotificationGeoLocation':
        """
        Gets the geolocation of this JourneySessionEventsNotificationSessionEvent.


        :return: The geolocation of this JourneySessionEventsNotificationSessionEvent.
        :rtype: JourneySessionEventsNotificationGeoLocation
        """
        return self._geolocation

    @geolocation.setter
    def geolocation(self, geolocation: 'JourneySessionEventsNotificationGeoLocation') -> None:
        """
        Sets the geolocation of this JourneySessionEventsNotificationSessionEvent.


        :param geolocation: The geolocation of this JourneySessionEventsNotificationSessionEvent.
        :type: JourneySessionEventsNotificationGeoLocation
        """
        

        self._geolocation = geolocation

    @property
    def idle_date(self) -> datetime:
        """
        Gets the idle_date of this JourneySessionEventsNotificationSessionEvent.


        :return: The idle_date of this JourneySessionEventsNotificationSessionEvent.
        :rtype: datetime
        """
        return self._idle_date

    @idle_date.setter
    def idle_date(self, idle_date: datetime) -> None:
        """
        Sets the idle_date of this JourneySessionEventsNotificationSessionEvent.


        :param idle_date: The idle_date of this JourneySessionEventsNotificationSessionEvent.
        :type: datetime
        """
        

        self._idle_date = idle_date

    @property
    def ip_address(self) -> str:
        """
        Gets the ip_address of this JourneySessionEventsNotificationSessionEvent.


        :return: The ip_address of this JourneySessionEventsNotificationSessionEvent.
        :rtype: str
        """
        return self._ip_address

    @ip_address.setter
    def ip_address(self, ip_address: str) -> None:
        """
        Sets the ip_address of this JourneySessionEventsNotificationSessionEvent.


        :param ip_address: The ip_address of this JourneySessionEventsNotificationSessionEvent.
        :type: str
        """
        

        self._ip_address = ip_address

    @property
    def ip_organization(self) -> str:
        """
        Gets the ip_organization of this JourneySessionEventsNotificationSessionEvent.


        :return: The ip_organization of this JourneySessionEventsNotificationSessionEvent.
        :rtype: str
        """
        return self._ip_organization

    @ip_organization.setter
    def ip_organization(self, ip_organization: str) -> None:
        """
        Sets the ip_organization of this JourneySessionEventsNotificationSessionEvent.


        :param ip_organization: The ip_organization of this JourneySessionEventsNotificationSessionEvent.
        :type: str
        """
        

        self._ip_organization = ip_organization

    @property
    def last_page(self) -> 'JourneySessionEventsNotificationPage':
        """
        Gets the last_page of this JourneySessionEventsNotificationSessionEvent.


        :return: The last_page of this JourneySessionEventsNotificationSessionEvent.
        :rtype: JourneySessionEventsNotificationPage
        """
        return self._last_page

    @last_page.setter
    def last_page(self, last_page: 'JourneySessionEventsNotificationPage') -> None:
        """
        Sets the last_page of this JourneySessionEventsNotificationSessionEvent.


        :param last_page: The last_page of this JourneySessionEventsNotificationSessionEvent.
        :type: JourneySessionEventsNotificationPage
        """
        

        self._last_page = last_page

    @property
    def mkt_campaign(self) -> 'JourneySessionEventsNotificationMktCampaign':
        """
        Gets the mkt_campaign of this JourneySessionEventsNotificationSessionEvent.


        :return: The mkt_campaign of this JourneySessionEventsNotificationSessionEvent.
        :rtype: JourneySessionEventsNotificationMktCampaign
        """
        return self._mkt_campaign

    @mkt_campaign.setter
    def mkt_campaign(self, mkt_campaign: 'JourneySessionEventsNotificationMktCampaign') -> None:
        """
        Sets the mkt_campaign of this JourneySessionEventsNotificationSessionEvent.


        :param mkt_campaign: The mkt_campaign of this JourneySessionEventsNotificationSessionEvent.
        :type: JourneySessionEventsNotificationMktCampaign
        """
        

        self._mkt_campaign = mkt_campaign

    @property
    def referrer(self) -> 'JourneySessionEventsNotificationReferrer':
        """
        Gets the referrer of this JourneySessionEventsNotificationSessionEvent.


        :return: The referrer of this JourneySessionEventsNotificationSessionEvent.
        :rtype: JourneySessionEventsNotificationReferrer
        """
        return self._referrer

    @referrer.setter
    def referrer(self, referrer: 'JourneySessionEventsNotificationReferrer') -> None:
        """
        Sets the referrer of this JourneySessionEventsNotificationSessionEvent.


        :param referrer: The referrer of this JourneySessionEventsNotificationSessionEvent.
        :type: JourneySessionEventsNotificationReferrer
        """
        

        self._referrer = referrer

    @property
    def search_terms(self) -> List[str]:
        """
        Gets the search_terms of this JourneySessionEventsNotificationSessionEvent.


        :return: The search_terms of this JourneySessionEventsNotificationSessionEvent.
        :rtype: list[str]
        """
        return self._search_terms

    @search_terms.setter
    def search_terms(self, search_terms: List[str]) -> None:
        """
        Sets the search_terms of this JourneySessionEventsNotificationSessionEvent.


        :param search_terms: The search_terms of this JourneySessionEventsNotificationSessionEvent.
        :type: list[str]
        """
        

        self._search_terms = search_terms

    @property
    def user_agent_string(self) -> str:
        """
        Gets the user_agent_string of this JourneySessionEventsNotificationSessionEvent.


        :return: The user_agent_string of this JourneySessionEventsNotificationSessionEvent.
        :rtype: str
        """
        return self._user_agent_string

    @user_agent_string.setter
    def user_agent_string(self, user_agent_string: str) -> None:
        """
        Sets the user_agent_string of this JourneySessionEventsNotificationSessionEvent.


        :param user_agent_string: The user_agent_string of this JourneySessionEventsNotificationSessionEvent.
        :type: str
        """
        

        self._user_agent_string = user_agent_string

    @property
    def duration_in_seconds(self) -> int:
        """
        Gets the duration_in_seconds of this JourneySessionEventsNotificationSessionEvent.


        :return: The duration_in_seconds of this JourneySessionEventsNotificationSessionEvent.
        :rtype: int
        """
        return self._duration_in_seconds

    @duration_in_seconds.setter
    def duration_in_seconds(self, duration_in_seconds: int) -> None:
        """
        Sets the duration_in_seconds of this JourneySessionEventsNotificationSessionEvent.


        :param duration_in_seconds: The duration_in_seconds of this JourneySessionEventsNotificationSessionEvent.
        :type: int
        """
        

        self._duration_in_seconds = duration_in_seconds

    @property
    def event_count(self) -> int:
        """
        Gets the event_count of this JourneySessionEventsNotificationSessionEvent.


        :return: The event_count of this JourneySessionEventsNotificationSessionEvent.
        :rtype: int
        """
        return self._event_count

    @event_count.setter
    def event_count(self, event_count: int) -> None:
        """
        Sets the event_count of this JourneySessionEventsNotificationSessionEvent.


        :param event_count: The event_count of this JourneySessionEventsNotificationSessionEvent.
        :type: int
        """
        

        self._event_count = event_count

    @property
    def pageview_count(self) -> int:
        """
        Gets the pageview_count of this JourneySessionEventsNotificationSessionEvent.


        :return: The pageview_count of this JourneySessionEventsNotificationSessionEvent.
        :rtype: int
        """
        return self._pageview_count

    @pageview_count.setter
    def pageview_count(self, pageview_count: int) -> None:
        """
        Sets the pageview_count of this JourneySessionEventsNotificationSessionEvent.


        :param pageview_count: The pageview_count of this JourneySessionEventsNotificationSessionEvent.
        :type: int
        """
        

        self._pageview_count = pageview_count

    @property
    def screenview_count(self) -> int:
        """
        Gets the screenview_count of this JourneySessionEventsNotificationSessionEvent.


        :return: The screenview_count of this JourneySessionEventsNotificationSessionEvent.
        :rtype: int
        """
        return self._screenview_count

    @screenview_count.setter
    def screenview_count(self, screenview_count: int) -> None:
        """
        Sets the screenview_count of this JourneySessionEventsNotificationSessionEvent.


        :param screenview_count: The screenview_count of this JourneySessionEventsNotificationSessionEvent.
        :type: int
        """
        

        self._screenview_count = screenview_count

    @property
    def last_event(self) -> 'JourneySessionEventsNotificationSessionLastEvent':
        """
        Gets the last_event of this JourneySessionEventsNotificationSessionEvent.


        :return: The last_event of this JourneySessionEventsNotificationSessionEvent.
        :rtype: JourneySessionEventsNotificationSessionLastEvent
        """
        return self._last_event

    @last_event.setter
    def last_event(self, last_event: 'JourneySessionEventsNotificationSessionLastEvent') -> None:
        """
        Sets the last_event of this JourneySessionEventsNotificationSessionEvent.


        :param last_event: The last_event of this JourneySessionEventsNotificationSessionEvent.
        :type: JourneySessionEventsNotificationSessionLastEvent
        """
        

        self._last_event = last_event

    @property
    def conversation(self) -> 'JourneySessionEventsNotificationConversation':
        """
        Gets the conversation of this JourneySessionEventsNotificationSessionEvent.


        :return: The conversation of this JourneySessionEventsNotificationSessionEvent.
        :rtype: JourneySessionEventsNotificationConversation
        """
        return self._conversation

    @conversation.setter
    def conversation(self, conversation: 'JourneySessionEventsNotificationConversation') -> None:
        """
        Sets the conversation of this JourneySessionEventsNotificationSessionEvent.


        :param conversation: The conversation of this JourneySessionEventsNotificationSessionEvent.
        :type: JourneySessionEventsNotificationConversation
        """
        

        self._conversation = conversation

    @property
    def originating_direction(self) -> str:
        """
        Gets the originating_direction of this JourneySessionEventsNotificationSessionEvent.


        :return: The originating_direction of this JourneySessionEventsNotificationSessionEvent.
        :rtype: str
        """
        return self._originating_direction

    @originating_direction.setter
    def originating_direction(self, originating_direction: str) -> None:
        """
        Sets the originating_direction of this JourneySessionEventsNotificationSessionEvent.


        :param originating_direction: The originating_direction of this JourneySessionEventsNotificationSessionEvent.
        :type: str
        """
        if isinstance(originating_direction, int):
            originating_direction = str(originating_direction)
        allowed_values = ["Unknown", "Inbound", "Outbound"]
        if originating_direction.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for originating_direction -> " + originating_direction)
            self._originating_direction = "outdated_sdk_version"
        else:
            self._originating_direction = originating_direction

    @property
    def conversation_subject(self) -> str:
        """
        Gets the conversation_subject of this JourneySessionEventsNotificationSessionEvent.


        :return: The conversation_subject of this JourneySessionEventsNotificationSessionEvent.
        :rtype: str
        """
        return self._conversation_subject

    @conversation_subject.setter
    def conversation_subject(self, conversation_subject: str) -> None:
        """
        Sets the conversation_subject of this JourneySessionEventsNotificationSessionEvent.


        :param conversation_subject: The conversation_subject of this JourneySessionEventsNotificationSessionEvent.
        :type: str
        """
        

        self._conversation_subject = conversation_subject

    @property
    def last_user_disposition(self) -> 'JourneySessionEventsNotificationConversationUserDisposition':
        """
        Gets the last_user_disposition of this JourneySessionEventsNotificationSessionEvent.


        :return: The last_user_disposition of this JourneySessionEventsNotificationSessionEvent.
        :rtype: JourneySessionEventsNotificationConversationUserDisposition
        """
        return self._last_user_disposition

    @last_user_disposition.setter
    def last_user_disposition(self, last_user_disposition: 'JourneySessionEventsNotificationConversationUserDisposition') -> None:
        """
        Sets the last_user_disposition of this JourneySessionEventsNotificationSessionEvent.


        :param last_user_disposition: The last_user_disposition of this JourneySessionEventsNotificationSessionEvent.
        :type: JourneySessionEventsNotificationConversationUserDisposition
        """
        

        self._last_user_disposition = last_user_disposition

    @property
    def last_connected_user(self) -> 'JourneySessionEventsNotificationUser':
        """
        Gets the last_connected_user of this JourneySessionEventsNotificationSessionEvent.


        :return: The last_connected_user of this JourneySessionEventsNotificationSessionEvent.
        :rtype: JourneySessionEventsNotificationUser
        """
        return self._last_connected_user

    @last_connected_user.setter
    def last_connected_user(self, last_connected_user: 'JourneySessionEventsNotificationUser') -> None:
        """
        Sets the last_connected_user of this JourneySessionEventsNotificationSessionEvent.


        :param last_connected_user: The last_connected_user of this JourneySessionEventsNotificationSessionEvent.
        :type: JourneySessionEventsNotificationUser
        """
        

        self._last_connected_user = last_connected_user

    @property
    def last_connected_queue(self) -> 'JourneySessionEventsNotificationConnectedQueue':
        """
        Gets the last_connected_queue of this JourneySessionEventsNotificationSessionEvent.


        :return: The last_connected_queue of this JourneySessionEventsNotificationSessionEvent.
        :rtype: JourneySessionEventsNotificationConnectedQueue
        """
        return self._last_connected_queue

    @last_connected_queue.setter
    def last_connected_queue(self, last_connected_queue: 'JourneySessionEventsNotificationConnectedQueue') -> None:
        """
        Sets the last_connected_queue of this JourneySessionEventsNotificationSessionEvent.


        :param last_connected_queue: The last_connected_queue of this JourneySessionEventsNotificationSessionEvent.
        :type: JourneySessionEventsNotificationConnectedQueue
        """
        

        self._last_connected_queue = last_connected_queue

    @property
    def conversation_channels(self) -> List['JourneySessionEventsNotificationConversationChannel']:
        """
        Gets the conversation_channels of this JourneySessionEventsNotificationSessionEvent.


        :return: The conversation_channels of this JourneySessionEventsNotificationSessionEvent.
        :rtype: list[JourneySessionEventsNotificationConversationChannel]
        """
        return self._conversation_channels

    @conversation_channels.setter
    def conversation_channels(self, conversation_channels: List['JourneySessionEventsNotificationConversationChannel']) -> None:
        """
        Sets the conversation_channels of this JourneySessionEventsNotificationSessionEvent.


        :param conversation_channels: The conversation_channels of this JourneySessionEventsNotificationSessionEvent.
        :type: list[JourneySessionEventsNotificationConversationChannel]
        """
        

        self._conversation_channels = conversation_channels

    @property
    def last_user_disconnect_type(self) -> str:
        """
        Gets the last_user_disconnect_type of this JourneySessionEventsNotificationSessionEvent.


        :return: The last_user_disconnect_type of this JourneySessionEventsNotificationSessionEvent.
        :rtype: str
        """
        return self._last_user_disconnect_type

    @last_user_disconnect_type.setter
    def last_user_disconnect_type(self, last_user_disconnect_type: str) -> None:
        """
        Sets the last_user_disconnect_type of this JourneySessionEventsNotificationSessionEvent.


        :param last_user_disconnect_type: The last_user_disconnect_type of this JourneySessionEventsNotificationSessionEvent.
        :type: str
        """
        if isinstance(last_user_disconnect_type, int):
            last_user_disconnect_type = str(last_user_disconnect_type)
        allowed_values = ["Unknown", "Endpoint", "Client", "System", "Transfer", "Error", "Peer", "Other", "Spam", "Timeout", "TransportFailure", "ConferenceTransfer", "ConsultTransfer", "ForwardTransfer", "NoAnswerTransfer", "NotAvailableTransfer", "Uncallable"]
        if last_user_disconnect_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for last_user_disconnect_type -> " + last_user_disconnect_type)
            self._last_user_disconnect_type = "outdated_sdk_version"
        else:
            self._last_user_disconnect_type = last_user_disconnect_type

    @property
    def last_acd_outcome(self) -> str:
        """
        Gets the last_acd_outcome of this JourneySessionEventsNotificationSessionEvent.


        :return: The last_acd_outcome of this JourneySessionEventsNotificationSessionEvent.
        :rtype: str
        """
        return self._last_acd_outcome

    @last_acd_outcome.setter
    def last_acd_outcome(self, last_acd_outcome: str) -> None:
        """
        Sets the last_acd_outcome of this JourneySessionEventsNotificationSessionEvent.


        :param last_acd_outcome: The last_acd_outcome of this JourneySessionEventsNotificationSessionEvent.
        :type: str
        """
        if isinstance(last_acd_outcome, int):
            last_acd_outcome = str(last_acd_outcome)
        allowed_values = ["Unknown", "Abandon", "Answered", "FlowOut"]
        if last_acd_outcome.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for last_acd_outcome -> " + last_acd_outcome)
            self._last_acd_outcome = "outdated_sdk_version"
        else:
            self._last_acd_outcome = last_acd_outcome

    @property
    def authenticated(self) -> bool:
        """
        Gets the authenticated of this JourneySessionEventsNotificationSessionEvent.


        :return: The authenticated of this JourneySessionEventsNotificationSessionEvent.
        :rtype: bool
        """
        return self._authenticated

    @authenticated.setter
    def authenticated(self, authenticated: bool) -> None:
        """
        Sets the authenticated of this JourneySessionEventsNotificationSessionEvent.


        :param authenticated: The authenticated of this JourneySessionEventsNotificationSessionEvent.
        :type: bool
        """
        

        self._authenticated = authenticated

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

