# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class GoogleDialogflowCustomSettings(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        GoogleDialogflowCustomSettings - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'environment': 'str',
            'event_name': 'str',
            'webhook_query_parameters': 'dict(str, str)',
            'event_input_parameters': 'dict(str, str)'
        }

        self.attribute_map = {
            'environment': 'environment',
            'event_name': 'eventName',
            'webhook_query_parameters': 'webhookQueryParameters',
            'event_input_parameters': 'eventInputParameters'
        }

        self._environment = None
        self._event_name = None
        self._webhook_query_parameters = None
        self._event_input_parameters = None

    @property
    def environment(self) -> str:
        """
        Gets the environment of this GoogleDialogflowCustomSettings.
        If set this environment will be used to initiate the dialogflow bot, otherwise the default configuration will be used.  See https://cloud.google.com/dialogflow/docs/agents-versions

        :return: The environment of this GoogleDialogflowCustomSettings.
        :rtype: str
        """
        return self._environment

    @environment.setter
    def environment(self, environment: str) -> None:
        """
        Sets the environment of this GoogleDialogflowCustomSettings.
        If set this environment will be used to initiate the dialogflow bot, otherwise the default configuration will be used.  See https://cloud.google.com/dialogflow/docs/agents-versions

        :param environment: The environment of this GoogleDialogflowCustomSettings.
        :type: str
        """
        

        self._environment = environment

    @property
    def event_name(self) -> str:
        """
        Gets the event_name of this GoogleDialogflowCustomSettings.
        If set this eventName will be used to initiate the dialogflow bot rather than language processing on the input text.  See https://cloud.google.com/dialogflow/es/docs/events-overview

        :return: The event_name of this GoogleDialogflowCustomSettings.
        :rtype: str
        """
        return self._event_name

    @event_name.setter
    def event_name(self, event_name: str) -> None:
        """
        Sets the event_name of this GoogleDialogflowCustomSettings.
        If set this eventName will be used to initiate the dialogflow bot rather than language processing on the input text.  See https://cloud.google.com/dialogflow/es/docs/events-overview

        :param event_name: The event_name of this GoogleDialogflowCustomSettings.
        :type: str
        """
        

        self._event_name = event_name

    @property
    def webhook_query_parameters(self) -> Dict[str, str]:
        """
        Gets the webhook_query_parameters of this GoogleDialogflowCustomSettings.
        Parameters passed to the fulfillment webhook of the bot (if any).

        :return: The webhook_query_parameters of this GoogleDialogflowCustomSettings.
        :rtype: dict(str, str)
        """
        return self._webhook_query_parameters

    @webhook_query_parameters.setter
    def webhook_query_parameters(self, webhook_query_parameters: Dict[str, str]) -> None:
        """
        Sets the webhook_query_parameters of this GoogleDialogflowCustomSettings.
        Parameters passed to the fulfillment webhook of the bot (if any).

        :param webhook_query_parameters: The webhook_query_parameters of this GoogleDialogflowCustomSettings.
        :type: dict(str, str)
        """
        

        self._webhook_query_parameters = webhook_query_parameters

    @property
    def event_input_parameters(self) -> Dict[str, str]:
        """
        Gets the event_input_parameters of this GoogleDialogflowCustomSettings.
        Parameters passed to the event input of the bot.

        :return: The event_input_parameters of this GoogleDialogflowCustomSettings.
        :rtype: dict(str, str)
        """
        return self._event_input_parameters

    @event_input_parameters.setter
    def event_input_parameters(self, event_input_parameters: Dict[str, str]) -> None:
        """
        Sets the event_input_parameters of this GoogleDialogflowCustomSettings.
        Parameters passed to the event input of the bot.

        :param event_input_parameters: The event_input_parameters of this GoogleDialogflowCustomSettings.
        :type: dict(str, str)
        """
        

        self._event_input_parameters = event_input_parameters

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

