# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import ContactAddressConditionSettings
    from . import ContactAddressTypeConditionSettings
    from . import ContactColumnConditionSettings
    from . import DataActionConditionSettings
    from . import LastAttemptByColumnConditionSettings
    from . import LastAttemptOverallConditionSettings
    from . import LastResultByColumnConditionSettings
    from . import LastResultOverallConditionSettings

class DigitalCondition(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        DigitalCondition - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'inverted': 'bool',
            'contact_column_condition_settings': 'ContactColumnConditionSettings',
            'contact_address_condition_settings': 'ContactAddressConditionSettings',
            'contact_address_type_condition_settings': 'ContactAddressTypeConditionSettings',
            'last_attempt_by_column_condition_settings': 'LastAttemptByColumnConditionSettings',
            'last_attempt_overall_condition_settings': 'LastAttemptOverallConditionSettings',
            'last_result_by_column_condition_settings': 'LastResultByColumnConditionSettings',
            'last_result_overall_condition_settings': 'LastResultOverallConditionSettings',
            'data_action_condition_settings': 'DataActionConditionSettings'
        }

        self.attribute_map = {
            'inverted': 'inverted',
            'contact_column_condition_settings': 'contactColumnConditionSettings',
            'contact_address_condition_settings': 'contactAddressConditionSettings',
            'contact_address_type_condition_settings': 'contactAddressTypeConditionSettings',
            'last_attempt_by_column_condition_settings': 'lastAttemptByColumnConditionSettings',
            'last_attempt_overall_condition_settings': 'lastAttemptOverallConditionSettings',
            'last_result_by_column_condition_settings': 'lastResultByColumnConditionSettings',
            'last_result_overall_condition_settings': 'lastResultOverallConditionSettings',
            'data_action_condition_settings': 'dataActionConditionSettings'
        }

        self._inverted = None
        self._contact_column_condition_settings = None
        self._contact_address_condition_settings = None
        self._contact_address_type_condition_settings = None
        self._last_attempt_by_column_condition_settings = None
        self._last_attempt_overall_condition_settings = None
        self._last_result_by_column_condition_settings = None
        self._last_result_overall_condition_settings = None
        self._data_action_condition_settings = None

    @property
    def inverted(self) -> bool:
        """
        Gets the inverted of this DigitalCondition.
        If true, inverts the result of evaluating this condition. Default is false.

        :return: The inverted of this DigitalCondition.
        :rtype: bool
        """
        return self._inverted

    @inverted.setter
    def inverted(self, inverted: bool) -> None:
        """
        Sets the inverted of this DigitalCondition.
        If true, inverts the result of evaluating this condition. Default is false.

        :param inverted: The inverted of this DigitalCondition.
        :type: bool
        """
        

        self._inverted = inverted

    @property
    def contact_column_condition_settings(self) -> 'ContactColumnConditionSettings':
        """
        Gets the contact_column_condition_settings of this DigitalCondition.
        The settings for a 'contact list column' condition.

        :return: The contact_column_condition_settings of this DigitalCondition.
        :rtype: ContactColumnConditionSettings
        """
        return self._contact_column_condition_settings

    @contact_column_condition_settings.setter
    def contact_column_condition_settings(self, contact_column_condition_settings: 'ContactColumnConditionSettings') -> None:
        """
        Sets the contact_column_condition_settings of this DigitalCondition.
        The settings for a 'contact list column' condition.

        :param contact_column_condition_settings: The contact_column_condition_settings of this DigitalCondition.
        :type: ContactColumnConditionSettings
        """
        

        self._contact_column_condition_settings = contact_column_condition_settings

    @property
    def contact_address_condition_settings(self) -> 'ContactAddressConditionSettings':
        """
        Gets the contact_address_condition_settings of this DigitalCondition.
        The settings for a 'contact address' condition.

        :return: The contact_address_condition_settings of this DigitalCondition.
        :rtype: ContactAddressConditionSettings
        """
        return self._contact_address_condition_settings

    @contact_address_condition_settings.setter
    def contact_address_condition_settings(self, contact_address_condition_settings: 'ContactAddressConditionSettings') -> None:
        """
        Sets the contact_address_condition_settings of this DigitalCondition.
        The settings for a 'contact address' condition.

        :param contact_address_condition_settings: The contact_address_condition_settings of this DigitalCondition.
        :type: ContactAddressConditionSettings
        """
        

        self._contact_address_condition_settings = contact_address_condition_settings

    @property
    def contact_address_type_condition_settings(self) -> 'ContactAddressTypeConditionSettings':
        """
        Gets the contact_address_type_condition_settings of this DigitalCondition.
        The settings for a 'contact address type' condition.

        :return: The contact_address_type_condition_settings of this DigitalCondition.
        :rtype: ContactAddressTypeConditionSettings
        """
        return self._contact_address_type_condition_settings

    @contact_address_type_condition_settings.setter
    def contact_address_type_condition_settings(self, contact_address_type_condition_settings: 'ContactAddressTypeConditionSettings') -> None:
        """
        Sets the contact_address_type_condition_settings of this DigitalCondition.
        The settings for a 'contact address type' condition.

        :param contact_address_type_condition_settings: The contact_address_type_condition_settings of this DigitalCondition.
        :type: ContactAddressTypeConditionSettings
        """
        

        self._contact_address_type_condition_settings = contact_address_type_condition_settings

    @property
    def last_attempt_by_column_condition_settings(self) -> 'LastAttemptByColumnConditionSettings':
        """
        Gets the last_attempt_by_column_condition_settings of this DigitalCondition.
        The settings for a 'last attempt by column' condition.

        :return: The last_attempt_by_column_condition_settings of this DigitalCondition.
        :rtype: LastAttemptByColumnConditionSettings
        """
        return self._last_attempt_by_column_condition_settings

    @last_attempt_by_column_condition_settings.setter
    def last_attempt_by_column_condition_settings(self, last_attempt_by_column_condition_settings: 'LastAttemptByColumnConditionSettings') -> None:
        """
        Sets the last_attempt_by_column_condition_settings of this DigitalCondition.
        The settings for a 'last attempt by column' condition.

        :param last_attempt_by_column_condition_settings: The last_attempt_by_column_condition_settings of this DigitalCondition.
        :type: LastAttemptByColumnConditionSettings
        """
        

        self._last_attempt_by_column_condition_settings = last_attempt_by_column_condition_settings

    @property
    def last_attempt_overall_condition_settings(self) -> 'LastAttemptOverallConditionSettings':
        """
        Gets the last_attempt_overall_condition_settings of this DigitalCondition.
        The settings for a 'last attempt overall' condition.

        :return: The last_attempt_overall_condition_settings of this DigitalCondition.
        :rtype: LastAttemptOverallConditionSettings
        """
        return self._last_attempt_overall_condition_settings

    @last_attempt_overall_condition_settings.setter
    def last_attempt_overall_condition_settings(self, last_attempt_overall_condition_settings: 'LastAttemptOverallConditionSettings') -> None:
        """
        Sets the last_attempt_overall_condition_settings of this DigitalCondition.
        The settings for a 'last attempt overall' condition.

        :param last_attempt_overall_condition_settings: The last_attempt_overall_condition_settings of this DigitalCondition.
        :type: LastAttemptOverallConditionSettings
        """
        

        self._last_attempt_overall_condition_settings = last_attempt_overall_condition_settings

    @property
    def last_result_by_column_condition_settings(self) -> 'LastResultByColumnConditionSettings':
        """
        Gets the last_result_by_column_condition_settings of this DigitalCondition.
        The settings for a 'last result by column' condition.

        :return: The last_result_by_column_condition_settings of this DigitalCondition.
        :rtype: LastResultByColumnConditionSettings
        """
        return self._last_result_by_column_condition_settings

    @last_result_by_column_condition_settings.setter
    def last_result_by_column_condition_settings(self, last_result_by_column_condition_settings: 'LastResultByColumnConditionSettings') -> None:
        """
        Sets the last_result_by_column_condition_settings of this DigitalCondition.
        The settings for a 'last result by column' condition.

        :param last_result_by_column_condition_settings: The last_result_by_column_condition_settings of this DigitalCondition.
        :type: LastResultByColumnConditionSettings
        """
        

        self._last_result_by_column_condition_settings = last_result_by_column_condition_settings

    @property
    def last_result_overall_condition_settings(self) -> 'LastResultOverallConditionSettings':
        """
        Gets the last_result_overall_condition_settings of this DigitalCondition.
        The settings for a 'last result overall' condition.

        :return: The last_result_overall_condition_settings of this DigitalCondition.
        :rtype: LastResultOverallConditionSettings
        """
        return self._last_result_overall_condition_settings

    @last_result_overall_condition_settings.setter
    def last_result_overall_condition_settings(self, last_result_overall_condition_settings: 'LastResultOverallConditionSettings') -> None:
        """
        Sets the last_result_overall_condition_settings of this DigitalCondition.
        The settings for a 'last result overall' condition.

        :param last_result_overall_condition_settings: The last_result_overall_condition_settings of this DigitalCondition.
        :type: LastResultOverallConditionSettings
        """
        

        self._last_result_overall_condition_settings = last_result_overall_condition_settings

    @property
    def data_action_condition_settings(self) -> 'DataActionConditionSettings':
        """
        Gets the data_action_condition_settings of this DigitalCondition.
        The settings for a 'data action' condition.

        :return: The data_action_condition_settings of this DigitalCondition.
        :rtype: DataActionConditionSettings
        """
        return self._data_action_condition_settings

    @data_action_condition_settings.setter
    def data_action_condition_settings(self, data_action_condition_settings: 'DataActionConditionSettings') -> None:
        """
        Sets the data_action_condition_settings of this DigitalCondition.
        The settings for a 'data action' condition.

        :param data_action_condition_settings: The data_action_condition_settings of this DigitalCondition.
        :type: DataActionConditionSettings
        """
        

        self._data_action_condition_settings = data_action_condition_settings

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

