# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import AnalyticsQueryAggregation
    from . import ConversationDetailQueryFilter
    from . import EvaluationDetailQueryFilter
    from . import PagingSpec
    from . import ResolutionDetailQueryFilter
    from . import SegmentDetailQueryFilter
    from . import SurveyDetailQueryFilter

class ConversationQuery(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        ConversationQuery - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'conversation_filters': 'list[ConversationDetailQueryFilter]',
            'segment_filters': 'list[SegmentDetailQueryFilter]',
            'evaluation_filters': 'list[EvaluationDetailQueryFilter]',
            'survey_filters': 'list[SurveyDetailQueryFilter]',
            'resolution_filters': 'list[ResolutionDetailQueryFilter]',
            'order': 'str',
            'order_by': 'str',
            'interval': 'str',
            'aggregations': 'list[AnalyticsQueryAggregation]',
            'paging': 'PagingSpec'
        }

        self.attribute_map = {
            'conversation_filters': 'conversationFilters',
            'segment_filters': 'segmentFilters',
            'evaluation_filters': 'evaluationFilters',
            'survey_filters': 'surveyFilters',
            'resolution_filters': 'resolutionFilters',
            'order': 'order',
            'order_by': 'orderBy',
            'interval': 'interval',
            'aggregations': 'aggregations',
            'paging': 'paging'
        }

        self._conversation_filters = None
        self._segment_filters = None
        self._evaluation_filters = None
        self._survey_filters = None
        self._resolution_filters = None
        self._order = None
        self._order_by = None
        self._interval = None
        self._aggregations = None
        self._paging = None

    @property
    def conversation_filters(self) -> List['ConversationDetailQueryFilter']:
        """
        Gets the conversation_filters of this ConversationQuery.
        Filters that target conversation-level data

        :return: The conversation_filters of this ConversationQuery.
        :rtype: list[ConversationDetailQueryFilter]
        """
        return self._conversation_filters

    @conversation_filters.setter
    def conversation_filters(self, conversation_filters: List['ConversationDetailQueryFilter']) -> None:
        """
        Sets the conversation_filters of this ConversationQuery.
        Filters that target conversation-level data

        :param conversation_filters: The conversation_filters of this ConversationQuery.
        :type: list[ConversationDetailQueryFilter]
        """
        

        self._conversation_filters = conversation_filters

    @property
    def segment_filters(self) -> List['SegmentDetailQueryFilter']:
        """
        Gets the segment_filters of this ConversationQuery.
        Filters that target individual segments within a conversation

        :return: The segment_filters of this ConversationQuery.
        :rtype: list[SegmentDetailQueryFilter]
        """
        return self._segment_filters

    @segment_filters.setter
    def segment_filters(self, segment_filters: List['SegmentDetailQueryFilter']) -> None:
        """
        Sets the segment_filters of this ConversationQuery.
        Filters that target individual segments within a conversation

        :param segment_filters: The segment_filters of this ConversationQuery.
        :type: list[SegmentDetailQueryFilter]
        """
        

        self._segment_filters = segment_filters

    @property
    def evaluation_filters(self) -> List['EvaluationDetailQueryFilter']:
        """
        Gets the evaluation_filters of this ConversationQuery.
        Filters that target evaluations

        :return: The evaluation_filters of this ConversationQuery.
        :rtype: list[EvaluationDetailQueryFilter]
        """
        return self._evaluation_filters

    @evaluation_filters.setter
    def evaluation_filters(self, evaluation_filters: List['EvaluationDetailQueryFilter']) -> None:
        """
        Sets the evaluation_filters of this ConversationQuery.
        Filters that target evaluations

        :param evaluation_filters: The evaluation_filters of this ConversationQuery.
        :type: list[EvaluationDetailQueryFilter]
        """
        

        self._evaluation_filters = evaluation_filters

    @property
    def survey_filters(self) -> List['SurveyDetailQueryFilter']:
        """
        Gets the survey_filters of this ConversationQuery.
        Filters that target surveys

        :return: The survey_filters of this ConversationQuery.
        :rtype: list[SurveyDetailQueryFilter]
        """
        return self._survey_filters

    @survey_filters.setter
    def survey_filters(self, survey_filters: List['SurveyDetailQueryFilter']) -> None:
        """
        Sets the survey_filters of this ConversationQuery.
        Filters that target surveys

        :param survey_filters: The survey_filters of this ConversationQuery.
        :type: list[SurveyDetailQueryFilter]
        """
        

        self._survey_filters = survey_filters

    @property
    def resolution_filters(self) -> List['ResolutionDetailQueryFilter']:
        """
        Gets the resolution_filters of this ConversationQuery.
        Filters that target resolutions

        :return: The resolution_filters of this ConversationQuery.
        :rtype: list[ResolutionDetailQueryFilter]
        """
        return self._resolution_filters

    @resolution_filters.setter
    def resolution_filters(self, resolution_filters: List['ResolutionDetailQueryFilter']) -> None:
        """
        Sets the resolution_filters of this ConversationQuery.
        Filters that target resolutions

        :param resolution_filters: The resolution_filters of this ConversationQuery.
        :type: list[ResolutionDetailQueryFilter]
        """
        

        self._resolution_filters = resolution_filters

    @property
    def order(self) -> str:
        """
        Gets the order of this ConversationQuery.
        Sort the result set in ascending/descending order. Default is ascending

        :return: The order of this ConversationQuery.
        :rtype: str
        """
        return self._order

    @order.setter
    def order(self, order: str) -> None:
        """
        Sets the order of this ConversationQuery.
        Sort the result set in ascending/descending order. Default is ascending

        :param order: The order of this ConversationQuery.
        :type: str
        """
        if isinstance(order, int):
            order = str(order)
        allowed_values = ["asc", "desc", "unordered"]
        if order.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for order -> " + order)
            self._order = "outdated_sdk_version"
        else:
            self._order = order

    @property
    def order_by(self) -> str:
        """
        Gets the order_by of this ConversationQuery.
        Specify which data element within the result set to use for sorting. The options  to use as a basis for sorting the results: conversationStart, segmentStart, and segmentEnd. If not specified, the default is conversationStart

        :return: The order_by of this ConversationQuery.
        :rtype: str
        """
        return self._order_by

    @order_by.setter
    def order_by(self, order_by: str) -> None:
        """
        Sets the order_by of this ConversationQuery.
        Specify which data element within the result set to use for sorting. The options  to use as a basis for sorting the results: conversationStart, segmentStart, and segmentEnd. If not specified, the default is conversationStart

        :param order_by: The order_by of this ConversationQuery.
        :type: str
        """
        if isinstance(order_by, int):
            order_by = str(order_by)
        allowed_values = ["conversationStart", "conversationEnd", "segmentStart", "segmentEnd"]
        if order_by.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for order_by -> " + order_by)
            self._order_by = "outdated_sdk_version"
        else:
            self._order_by = order_by

    @property
    def interval(self) -> str:
        """
        Gets the interval of this ConversationQuery.
        Specifies the date and time range of data being queried. Results will only include conversations that started on a day touched by the interval. Intervals are represented as an ISO-8601 string. For example: YYYY-MM-DDThh:mm:ss/YYYY-MM-DDThh:mm:ss

        :return: The interval of this ConversationQuery.
        :rtype: str
        """
        return self._interval

    @interval.setter
    def interval(self, interval: str) -> None:
        """
        Sets the interval of this ConversationQuery.
        Specifies the date and time range of data being queried. Results will only include conversations that started on a day touched by the interval. Intervals are represented as an ISO-8601 string. For example: YYYY-MM-DDThh:mm:ss/YYYY-MM-DDThh:mm:ss

        :param interval: The interval of this ConversationQuery.
        :type: str
        """
        

        self._interval = interval

    @property
    def aggregations(self) -> List['AnalyticsQueryAggregation']:
        """
        Gets the aggregations of this ConversationQuery.
        Include faceted search and aggregate roll-ups describing your search results. This does not function as a filter, but rather, summary data about the data matching your filters

        :return: The aggregations of this ConversationQuery.
        :rtype: list[AnalyticsQueryAggregation]
        """
        return self._aggregations

    @aggregations.setter
    def aggregations(self, aggregations: List['AnalyticsQueryAggregation']) -> None:
        """
        Sets the aggregations of this ConversationQuery.
        Include faceted search and aggregate roll-ups describing your search results. This does not function as a filter, but rather, summary data about the data matching your filters

        :param aggregations: The aggregations of this ConversationQuery.
        :type: list[AnalyticsQueryAggregation]
        """
        

        self._aggregations = aggregations

    @property
    def paging(self) -> 'PagingSpec':
        """
        Gets the paging of this ConversationQuery.
        Page size and number to control iterating through large result sets. Default page size is 25

        :return: The paging of this ConversationQuery.
        :rtype: PagingSpec
        """
        return self._paging

    @paging.setter
    def paging(self, paging: 'PagingSpec') -> None:
        """
        Sets the paging of this ConversationQuery.
        Page size and number to control iterating through large result sets. Default page size is 25

        :param paging: The paging of this ConversationQuery.
        :type: PagingSpec
        """
        

        self._paging = paging

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

